/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.pagebuilder;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.pagebuilder.PageBuilderResponseWrapper;
import com.atlassian.jira.web.pagebuilder.BootstrapPageBuilderServiceSpi;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.PageBuilderServiceSpi;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.compatability.HTMLPage2Content;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class PageBuilderFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PageBuilderFilter.class);
    private final String filterName = this.getClass().getCanonicalName() + "_alreadyfiltered";
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (request.getAttribute(this.filterName) != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(this.filterName, (Object)Boolean.TRUE);
        if (log.isDebugEnabled()) {
            log.debug(String.format("PageBuilderFilter decorated servlet path [%s] ", request.getServletPath()));
        }
        PageBuilderResponseWrapper responseWrapper = new PageBuilderResponseWrapper(response);
        try {
            PageBuilderFilter.getPageBuilderServiceSpi().initForRequest(request, response, responseWrapper, this.filterConfig.getServletContext());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            if (responseWrapper.isBuffering()) {
                Page page = responseWrapper.getBuffer().parse();
                this.renderDecoratablePage((Content)new HTMLPage2Content((HTMLPage)page));
            }
        }
        finally {
            PageBuilderFilter.getPageBuilderServiceSpi().clearForRequest();
            request.removeAttribute(this.filterName);
        }
    }

    private void renderDecoratablePage(final Content content) {
        PageBuilderFilter.getPageBuilderServiceSpi().getSpi().finish(new DecoratablePage(){

            @Override
            public String getTitle() {
                return content.getTitle();
            }

            @Override
            public String getMetaProperty(String key) {
                return content.getProperty("meta." + key);
            }

            @Override
            public String getBodyTagProperty(String key) {
                return content.getProperty("body." + key);
            }

            @Override
            public String getPageProperty(String key) {
                return content.getProperty("page." + key);
            }

            @Override
            public void writeHead(Writer writer) {
                try {
                    content.writeHead(writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void writeBody(Writer writer) {
                try {
                    content.writeBody(writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    private static PageBuilderServiceSpi getPageBuilderServiceSpi() {
        return ComponentAccessor.getComponentSafely(PageBuilderServiceSpi.class).orElseGet(BootstrapPageBuilderServiceSpi::new);
    }
}

