/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.jira.security.annotated.AnnotatedSecurityEnabledCheck;
import com.atlassian.jira.security.annotated.SecureDefaultsStats;
import com.atlassian.jira.servlet.ServletRequestUtil;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import com.atlassian.sal.core.permission.AccessType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessCheckFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AccessCheckFilter.class);
    private static final Map<String, AccessType> FILTER_TO_ACCESS_TYPE_SHORTCUT = new ImmutableMap.Builder().put((Object)"com.atlassian.prettyurls.filter.PrettyUrlsCombinedMatchDispatcherFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.prettyurls.filter.PrettyUrlsDispatcherFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.prettyurls.filter.PrettyUrlsMatcherFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.prettyurls.filter.PrettyUrlsSiteMeshFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.prettyurls.filter.PrettyUrlsSiteMeshFixupFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.web.servlet.plugin.LocationCleanerFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.web.servlet.plugin.ThreadIdFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.web.servlet.plugin.request.RedirectInterceptingFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.web.servlet.plugin.RedirectMeFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.analytics.client.filter.JiraAnalyticsFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.analytics.client.filter.UniversalAnalyticsFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.app.usage.core.features.common.usage.rest.filter.CapturingRestFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.app.usage.core.features.user.interaction.servlet.filter.CapturingServletFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.applinks.basic.rest.context.ContextFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.applinks.core.rest.context.ContextFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.applinks.cors.rest.context.ContextFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.applinks.oauth.rest.context.ContextFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.applinks.trusted.rest.context.ContextFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.diagnostics.internal.platform.monitor.http.HttpRequestMonitoringFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.baseurl.IncludeResourcesFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.tzdetect.IncludeResourcesFilter", (Object)AccessType.UNLICENSED_SITE_ACCESS).put((Object)"com.atlassian.jira.mobile.servlet.filter.DesktopSwitchFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.mobile.servlet.filter.MobileAuthenticationFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.mobile.servlet.filter.MobileRedirectFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.plugin.mobile.login.MobileLoginSuccessFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.plugin.mobile.web.filter.MobileAppRequestFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.plugin.mobile.web.filter.ServerInfoFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jwt.internal.servlet.JwtAuthFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.labs.botkiller.BotKillerFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.mywork.client.filter.ServingRequestsFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.oauth.serviceprovider.internal.servlet.OAuthFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.oauth2.provider.core.web.AccessTokenFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.oauth2.scopes.web.ReadWriteScopeFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.pats.web.filter.TokenBasedAuthenticationFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugin.servlet.filter.DelegatingPluginFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.authentication.basicauth.filter.DisableBasicAuthFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.authentication.sso.web.filter.authentication.SeraphAuthenticationFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.authentication.sso.web.filter.loginform.JsmAwareDisableNativeLoginAuthFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.authentication.sso.web.filter.logout.LogoutFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.authentication.sso.web.filter.ErrorHandlingFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.labs.httpservice.resource.ResourceFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.rest.module.servlet.RestSeraphFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.rest.module.servlet.RestServletFilterModuleContainerServlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.rest.module.servlet.RestServletUtilsUpdaterFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.rest.v2.servlet.RestServletFilterModuleContainerServlet", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.plugins.rest.v2.servlet.RestServletUtilsUpdaterFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.ratelimiting.internal.filter.RateLimitFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.ratelimiting.internal.filter.RateLimitPreAuthFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.theme.filter.DefaultRequestOverrideServletFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.troubleshooting.thready.filter.UrlThreadNamingFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.troubleshooting.thready.filter.UserThreadNamingFilter", (Object)AccessType.UNLICENSED_SITE_ACCESS).put((Object)"com.atlassian.gadgets.renderer.internal.servlet.GadgetSpecUrlRenderPermissionServletFilter", (Object)AccessType.LICENSED_ONLY).put((Object)"com.atlassian.jira.collector.plugin.components.bootstrap.OldBootstrapScriptUrlRedirectFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.collector.plugin.transformer.IssueCollectorP3PFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.collector.plugin.transformer.LegacyJQueryProviderFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.collector.plugin.transformer.WebResourceFixererUpper", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"org.apache.shindig.auth.AuthenticationServletFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.crowd.plugin.rest.filter.BasicApplicationAuthenticationFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.crowd.plugin.rest.filter.RestServiceVersionFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.crowd.plugin.rest.filter.SeraphDisablerFilter", (Object)AccessType.UNRESTRICTED_ACCESS).put((Object)"com.atlassian.jira.web.filters.security.TestAccessCheckFilter$AdminOnlyFilter", (Object)AccessType.SYSTEM_ADMIN_ONLY).build();
    private final Filter filter;
    private final String innerFilterClassName;
    private final AccessType accessType;
    private final AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck;
    private final Supplier<AnnotatedSecurityChecker> securityCheckerSupplier;

    public static Filter maybeWrap(Filter filter) {
        return AccessCheckFilter.maybeWrap(filter, filter, new AnnotatedSecurityEnabledCheck(), ServletRequestUtil::getSecurityChecker);
    }

    public static Filter maybeWrap(DelegatingPluginFilter filter) {
        return AccessCheckFilter.maybeWrap((Filter)filter, filter.getDelegatingFilter(), new AnnotatedSecurityEnabledCheck(), ServletRequestUtil::getSecurityChecker);
    }

    @VisibleForTesting
    static Filter maybeWrap(Filter filter, Filter innerFilter, AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        AccessType accessType = AccessCheckFilter.getAccessType(innerFilter);
        return accessType == AccessType.UNRESTRICTED_ACCESS ? filter : new AccessCheckFilter(filter, innerFilter.getClass().getName(), accessType, annotatedSecurityEnabledCheck, securityCheckerSupplier);
    }

    private AccessCheckFilter(Filter filter, String innerFilterClassName, AccessType accessType, AnnotatedSecurityEnabledCheck annotatedSecurityEnabledCheck, Supplier<AnnotatedSecurityChecker> securityCheckerSupplier) {
        Preconditions.checkArgument((accessType != AccessType.UNRESTRICTED_ACCESS ? 1 : 0) != 0);
        this.filter = Objects.requireNonNull(filter);
        this.innerFilterClassName = Objects.requireNonNull(innerFilterClassName);
        this.accessType = Objects.requireNonNull(accessType);
        this.annotatedSecurityEnabledCheck = annotatedSecurityEnabledCheck;
        this.securityCheckerSupplier = Objects.requireNonNull(securityCheckerSupplier);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.annotatedSecurityEnabledCheck.isAnnotatedSecurityDisabled() || this.securityCheckerSupplier.get().isAllowedFor(this.accessType)) {
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.filterAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
            this.filter.doFilter(request, response, chain);
        } else {
            if (log.isDebugEnabled()) {
                if (this.accessType == AccessType.EMPTY) {
                    log.debug("{} Skipping filter {} as it is not allowed for the current user. The filter has no security annotation and so we use the default value.", (Object)"[SECURITY ANNOTATION CHECK]", (Object)this.innerFilterClassName);
                } else {
                    log.debug("{} Skipping filter {} as it is not allowed for the current user. The filter has accessType={}.", new Object[]{"[SECURITY ANNOTATION CHECK]", this.innerFilterClassName, this.accessType});
                }
            }
            ComponentAccessor.getComponentSafely(SecureDefaultsStats.class).ifPresent(stats -> stats.filterNotAllowed(stopwatch.elapsed(TimeUnit.MICROSECONDS)));
            chain.doFilter(request, response);
        }
    }

    @VisibleForTesting
    Filter getFilter() {
        return this.filter;
    }

    private static AccessType getAccessType(Filter filter) {
        AccessType accessType = FILTER_TO_ACCESS_TYPE_SHORTCUT.get(filter.getClass().getName());
        if (accessType == null) {
            accessType = AccessType.getAccessType(filter.getClass(), (String)"doFilter", (Class[])new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class});
        }
        return accessType;
    }
}

