/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.security;

import com.atlassian.jira.web.filters.security.AccessCheckFilter;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.DelegatingPluginFilter;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import io.atlassian.fugue.Iterables;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class EnhancedServletModuleManagerWrapper
implements ServletModuleManager {
    private final ServletModuleManager delegate;

    public EnhancedServletModuleManagerWrapper(ServletModuleManager delegate) {
        this.delegate = delegate;
    }

    public void addServletModule(ServletModuleDescriptor descriptor) {
        this.delegate.addServletModule(descriptor);
    }

    public HttpServlet getServlet(String path, ServletConfig servletConfig) throws ServletException {
        return this.delegate.getServlet(path, servletConfig);
    }

    public void removeServletModule(ServletModuleDescriptor descriptor) {
        this.delegate.removeServletModule(descriptor);
    }

    public void addFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.delegate.addFilterModule(descriptor);
    }

    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, FilterDispatcherCondition condition) throws ServletException {
        Iterable filters = this.delegate.getFilters(location, pathInfo, filterConfig, condition);
        return this.enhanceWithAccessCheck(filters);
    }

    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, DispatcherType dispatcher) {
        Iterable filters = this.delegate.getFilters(location, pathInfo, filterConfig, dispatcher);
        return this.enhanceWithAccessCheck(filters);
    }

    public void removeFilterModule(ServletFilterModuleDescriptor descriptor) {
        this.delegate.removeFilterModule(descriptor);
    }

    public void addServlet(Plugin plugin, String servletName, String className) {
        this.delegate.addServlet(plugin, servletName, className);
    }

    public void addServlet(Plugin plugin, String servletName, HttpServlet servlet, ServletContext servletContext) {
        this.delegate.addServlet(plugin, servletName, servlet, servletContext);
    }

    private Iterable<Filter> enhanceWithAccessCheck(Iterable<Filter> originalFilters) {
        return Iterables.map(originalFilters, filter -> AccessCheckFilter.maybeWrap((DelegatingPluginFilter)filter));
    }
}

