/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.newrelic;

import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class NewRelicTransactionNameStep
implements FilterStep {
    private static List<Function<String, String>> RULES = Arrays.asList(NewRelicTransactionNameStep.startsWith("/secure/admin/", false), NewRelicTransactionNameStep.endsWith(".jspa"), NewRelicTransactionNameStep.startsWith("/secure/", false), NewRelicTransactionNameStep.startsWith("/browse/", false), NewRelicTransactionNameStep.startsWith("/plugins/servlet/", true), NewRelicTransactionNameStep.startsWith("/rest/", true));

    private static Function<String, String> startsWith(final String prefix, final boolean captureNext) {
        return new Function<String, String>(){

            public String apply(String uri) {
                if (uri.startsWith(prefix)) {
                    if (!captureNext) {
                        return prefix + "*";
                    }
                    String rest = uri.substring(prefix.length());
                    int i = rest.indexOf(47);
                    if (i > 0) {
                        return prefix + rest.substring(0, i) + "/*";
                    }
                    return prefix + "*";
                }
                return null;
            }
        };
    }

    private static Function<String, String> endsWith(final String suffix) {
        final String name = "/*" + suffix;
        return new Function<String, String>(){

            public String apply(String uri) {
                return uri.endsWith(suffix) ? name : null;
            }
        };
    }

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        String result;
        HttpServletRequest req = callContext.getHttpServletRequest();
        String cp = req.getContextPath();
        Object requestURI = req.getRequestURI();
        if (((String)requestURI).startsWith(cp)) {
            requestURI = ((String)requestURI).substring(cp.length());
        }
        if (!((String)requestURI).startsWith("/")) {
            requestURI = "/" + (String)requestURI;
        }
        if ((result = NewRelicTransactionNameStep.calculateName((String)requestURI)) != null) {
            req.setAttribute("com.newrelic.agent.TRANSACTION_NAME", (Object)result);
        }
        return callContext;
    }

    static String calculateName(String requestURI) {
        for (Function<String, String> rule : RULES) {
            String name = (String)rule.apply((Object)requestURI);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        return callContext;
    }
}

