/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security.csp;

import com.atlassian.jira.web.filters.steps.security.csp.Browser;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class CspSandboxBrowserDifferentiationValidator
implements Validator {
    private static final String OPTION_REGEX = "^$|(^\\w+:[\\w-]+(\\s[\\w-]+)*(;[\\w]+:([\\w-]+)(\\s[\\w-]+)*)*$)";
    private static final Set<String> allowedBrowsers = Arrays.stream(Browser.values()).map(Browser::getKey).collect(Collectors.toSet());
    private static final Set<String> allowedClauses = ImmutableSet.of((Object)"allow-downloads-without-user-activation", (Object)"allow-forms", (Object)"allow-modals", (Object)"allow-orientation-lock", (Object)"allow-pointer-lock", (Object)"allow-popups", (Object[])new String[]{"allow-popups-to-escape-sandbox", "allow-presentation", "allow-same-origin", "allow-scripts", "allow-storage-access-by-user-activation", "allow-top-navigation", "allow-top-navigation-by-user-activation"});
    private static final String ALLOWED_BROWSERS_MESSAGE = "Allowed browsers are: " + CspSandboxBrowserDifferentiationValidator.getAllowedBrowsersString() + ".";
    private static final String CLAUSES_MESSAGE = "Clauses are listed at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/sandbox";

    private static String getAllowedBrowsersString() {
        return String.join((CharSequence)", ", allowedBrowsers);
    }

    @Override
    public Validator.Result validate(String value) {
        if (!value.matches(OPTION_REGEX)) {
            return new Failure("Bad option formatting, should be 'browser:clause1 clause2;browser:clause...' without semicolon at the end." + ALLOWED_BROWSERS_MESSAGE + CLAUSES_MESSAGE);
        }
        if (value.trim().isEmpty()) {
            return new Success(value);
        }
        String[] entries = value.split(";");
        Set browsers = Arrays.stream(entries).map(entry -> entry.split(":")[0]).collect(Collectors.toSet());
        Set clauses = Arrays.stream(entries).map(entry -> entry.split(":")[1]).flatMap(clause -> Arrays.stream(clause.split(" "))).collect(Collectors.toSet());
        for (String browser : browsers) {
            if (allowedBrowsers.contains(browser)) continue;
            return new Failure("Unknown browser: '" + browser + "'." + ALLOWED_BROWSERS_MESSAGE);
        }
        for (String clause2 : clauses) {
            if (allowedClauses.contains(clause2)) continue;
            return new Failure("Unknown sandbox clause: '" + clause2 + "'.Clauses are listed at https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/sandbox");
        }
        return new Success(value);
    }
}

