/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.less;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.web.util.CssSubstitutionWebResourceTransformer;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LookAndFeelLessProvider {
    private static final Pattern CSS_LITERAL = Pattern.compile("^(([A-Za-z-]+)|(#[A-Za-z0-9]+)|(\\d*\\.?\\d+? *(px|%|em|pc|ex|in|deg|s|ms|pt|cm|mm|rad|grad|turn)?)|[\"'])$");
    private final ApplicationProperties applicationProperties;
    private final WebResourceIntegration webResourceIntegration;

    public LookAndFeelLessProvider(ApplicationProperties applicationProperties, WebResourceIntegration webResourceIntegration) {
        this.applicationProperties = applicationProperties;
        this.webResourceIntegration = webResourceIntegration;
    }

    public String makeLookAndFeelLess() {
        LookAndFeelBean laf = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        CssSubstitutionWebResourceTransformer.VariableMap variableMap = new CssSubstitutionWebResourceTransformer.VariableMap(laf, this.webResourceIntegration);
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, String> entry : variableMap.getVariableMap(false).entrySet()) {
            out.append("@").append(entry.getKey()).append(": ");
            out.append(this.encodeValue(entry.getValue())).append(";\n");
        }
        return out.toString();
    }

    public String encodeState() {
        return LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties).getSettingsHash();
    }

    private String encodeValue(String value) {
        if (CSS_LITERAL.matcher(value = StringUtils.trimToEmpty((String)value)).matches()) {
            return value;
        }
        value = value.replaceAll("['\"]", "\\$0");
        return "\"" + value + "\"";
    }
}

