/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.web.RequestAssetPhaseStore;
import com.atlassian.jira.web.pagebuilder.PageBuildingException;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import java.io.IOException;
import java.io.Writer;

public class CommonWebResourcesProvider {
    private final PageBuilderService pageBuilderService;
    private final RequestAssetPhaseStore requestAssetPhaseStore;
    private final FeatureManager featureManager;

    public CommonWebResourcesProvider(PageBuilderService pageBuilderService, RequestAssetPhaseStore requestAssetPhaseStore, FeatureManager featureManager) {
        this.pageBuilderService = pageBuilderService;
        this.requestAssetPhaseStore = requestAssetPhaseStore;
        this.featureManager = featureManager;
    }

    public void requireCommonWebResources() {
        this.pageBuilderService.assembler().resources().requireWebResource(ResourcePhase.INLINE, "jira.webresources:resource-phase-checkpoint-init").requireWebResource(ResourcePhase.REQUIRE, "jira.webresources:event-deferrer").requireSuperbatch(this.requestAssetPhaseStore.getPhase()).requireContext(this.requestAssetPhaseStore.getPhase(), "atl.global").requireContext(this.requestAssetPhaseStore.getPhase(), "jira.global").requireContext(this.requestAssetPhaseStore.getPhase(), "atl.general").requireContext(this.requestAssetPhaseStore.getPhase(), "jira.general").requireContext(this.requestAssetPhaseStore.getPhase(), "jira.global.look-and-feel");
    }

    public void drainIncludedWebResources(Writer out) {
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags(out, UrlMode.AUTO);
        try {
            out.flush();
        }
        catch (IOException ex) {
            throw new PageBuildingException("Cannot flush drained resources.", ex);
        }
    }
}

