/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.web.HttpRequestLocal;
import com.atlassian.jira.web.pagebuilder.DefaultPageBuilder;
import com.atlassian.jira.web.pagebuilder.FlushEarlyListener;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.pagebuilder.PageBuilderServiceSpi;
import com.atlassian.jira.web.pagebuilder.PageBuilderSpi;
import com.atlassian.jira.web.pagebuilder.PartialPageRenderer;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.assembler.DefaultPageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultJiraPageBuilderService
extends DefaultPageBuilderService
implements JiraPageBuilderService,
PageBuilderServiceSpi {
    private final ServerMetricsDetailCollector serverMetricsDetailCollector;
    private final HttpRequestLocal<DefaultPageBuilder> pageBuilderRequestLocal = new HttpRequestLocal("page.builder");

    public DefaultJiraPageBuilderService(WebResourceIntegration webResourceIntegration, WebResourceAssemblerFactory webResourceAssemblerFactory, ServerMetricsDetailCollector serverMetricsDetailCollector) {
        super(webResourceIntegration, webResourceAssemblerFactory);
        this.serverMetricsDetailCollector = serverMetricsDetailCollector;
    }

    @Override
    public void initForRequest(HttpServletRequest request, HttpServletResponse response, FlushEarlyListener flushEarlyListener, ServletContext servletContext) {
        if (null == this.pageBuilderRequestLocal.get()) {
            this.pageBuilderRequestLocal.set(new DefaultPageBuilder(request, response, servletContext, this.serverMetricsDetailCollector, flushEarlyListener));
        }
    }

    @Override
    public void clearForRequest() {
        this.pageBuilderRequestLocal.remove();
    }

    @Override
    public PartialPageRenderer getPartialPageRenderer() {
        DefaultPageBuilder pageBuilder = this.pageBuilderRequestLocal.get();
        if (null == pageBuilder) {
            throw new IllegalStateException("PageBuilderService.getPartialPageRenderer() called before page builder has been initialised for this request");
        }
        return pageBuilder;
    }

    @Override
    public PageBuilderSpi getSpi() {
        PageBuilderSpi pageBuilderSpi = this.pageBuilderRequestLocal.get();
        if (null == pageBuilderSpi) {
            throw new IllegalStateException("PageBuilderServiceSpi.getSpi() called before page builder has been initialised for this request");
        }
        return pageBuilderSpi;
    }
}

