/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class AvatarToStream {
    private final AvatarManager avatarManager;

    public AvatarToStream(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public void sendAvatar(AvatarData avatarData, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AvatarFormatPolicy avatarFormatPolicy = AvatarToStream.toAvatarRequestedFormat(Optional.ofNullable(request.getParameter("format")));
        this.avatarManager.readAvatarData(avatarData.getAvatar(), avatarData.getSize(), avatarFormatPolicy, new MediaConsumer(arg_0 -> ((HttpServletResponse)response).setContentType(arg_0), this.getDataConsumer(response, avatarData.getCachePolicy())));
    }

    @VisibleForTesting
    Consumer<InputStream> getDataConsumer(@Nonnull HttpServletResponse response, @Nonnull CachePolicy cachePolicy) {
        return stream -> {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                cachePolicy.applyTo(response);
                response.setContentLength(bytes.length);
                response.getOutputStream().write(bytes);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static AvatarFormatPolicy toAvatarRequestedFormat(Optional<String> imageFormat) {
        return imageFormat.filter(format -> !format.isEmpty()).map(String::toUpperCase).map(format -> {
            switch (format) {
                case "PNG": {
                    return AvatarFormatPolicy.createPngFormatPolicy().withFallingBackToOriginalDataStrategy();
                }
            }
            return AvatarFormatPolicy.createOriginalDataPolicy();
        }).orElse(AvatarFormatPolicy.createOriginalDataPolicy());
    }

    public static class AvatarData {
        final Avatar avatar;
        final Avatar.Size size;
        final CachePolicy cachePolicy;

        public AvatarData(@Nonnull Avatar avatar, @Nonnull Avatar.Size size, @Nullable CachePolicy cachePolicy) {
            this.avatar = avatar;
            this.size = size;
            this.cachePolicy = cachePolicy != null ? cachePolicy : CachePolicies.YEARS_1;
        }

        public AvatarData(@Nonnull Avatar avatar, @Nonnull Avatar.Size size) {
            this(avatar, size, null);
        }

        @Nonnull
        public Avatar getAvatar() {
            return this.avatar;
        }

        @Nonnull
        public Avatar.Size getSize() {
            return this.size;
        }

        @Nonnull
        public CachePolicy getCachePolicy() {
            return this.cachePolicy;
        }
    }

    public static interface CachePolicy {
        public void applyTo(HttpServletResponse var1);
    }

    public static enum CachePolicies implements CachePolicy
    {
        DAYS_1((Consumer<HttpServletResponse>)((Consumer)response -> HttpResponseHeaders.cachePrivatelyForSeconds(response, 86400L))),
        YEARS_1((Consumer<HttpServletResponse>)((Consumer)HttpResponseHeaders::cachePrivatelyForAboutOneYear));

        final Consumer<HttpServletResponse> setCacheHeaders;

        private CachePolicies(Consumer<HttpServletResponse> setCacheHeaders) {
            this.setCacheHeaders = setCacheHeaders;
        }

        @Override
        public void applyTo(HttpServletResponse httpServletResponse) {
            this.setCacheHeaders.consume((Object)httpServletResponse);
        }
    }
}

