/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.servlet.AbstractFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.renderer.util.FileTypeUtil;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@OpenAPIDefinition
@Path(value="download")
@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
@Tag(name="servlet")
@UnrestrictedAccess
public class FileServerServlet
extends AbstractFileServerServlet {
    @GET
    @Operation(description="Returns decoded download reference.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="pathInfo", description="url to decode.", in=ParameterIn.PATH, required=true)
    @ApiResponse(description="Request processed successfully.", responseCode="200")
    public String getDecodedPathInfo(HttpServletRequest httpServletRequest) {
        return this.urlDecode(httpServletRequest.getPathInfo());
    }

    protected String urlDecode(String url) {
        try {
            return url == null ? null : URLCodec.decode((String)url, (String)this.getCharacterEncoding());
        }
        catch (Exception e) {
            return url;
        }
    }

    protected String getContentType(String location) {
        return FileTypeUtil.getContentType((String)location);
    }

    private String getCharacterEncoding() {
        return ComponentAccessor.getApplicationProperties().getEncoding();
    }

    protected List<DownloadStrategy> getDownloadStrategies() {
        return CollectionBuilder.newBuilder((Object[])new DownloadStrategy[]{(DownloadStrategy)ComponentAccessor.getComponentOfType(DownloadStrategy.class)}).asList();
    }
}

