/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.issueview.IssueViewURLHandler;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@OpenAPIDefinition
@Path(value="si")
@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
@Tag(name="servlet")
@AnonymousSiteAccess
public class IssueViewServlet
extends HttpServlet {
    @GET
    @Path(value="{issueIdOrKey}")
    @Operation(description="Views issue using indicated module.")
    @Parameter(name="issueIdOrKey", description="Issue id.", in=ParameterIn.PATH)
    @ApiResponses(value={@ApiResponse(description="Returns the particular issue.", responseCode="200"), @ApiResponse(description="Processing the request was unsuccessful.", responseCode="400"), @ApiResponse(description="Issue with given id was not found.", responseCode="404")})
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(JiraUrl.constructBaseUrl((HttpServletRequest)request), request);
        IssueViewURLHandler urlHandler = (IssueViewURLHandler)ComponentAccessor.getComponentOfType(IssueViewURLHandler.class);
        urlHandler.handleRequest(request, response);
    }
}

