/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsSender;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class JohnsonAnalyticsServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        if (request.getRequestURI().endsWith("/analytics/event")) {
            Optional<String> eventId = this.getEventId(request);
            if (eventId.isPresent()) {
                this.sendHelpLinkClickedEvent(eventId.get());
                response.setStatus(200);
            } else {
                response.setStatus(400);
            }
        } else if (request.getRequestURI().endsWith("/analytics/KBArticleLinkClicked")) {
            Optional<String> kbUrlClicked = this.getKBUrlClicked(request);
            if (kbUrlClicked.isPresent()) {
                this.sendHelpLinkClickedEventForNonEventJohnsonPage();
                response.setStatus(200);
            } else {
                response.setStatus(400);
            }
        } else {
            response.setStatus(404);
        }
    }

    private void sendHelpLinkClickedEventForNonEventJohnsonPage() {
        ComponentAccessor.getComponentSafely(HealthCheckAnalyticsSender.class).ifPresent(HealthCheckAnalyticsSender::sendHelpLinkClickedForEventHiddenPage);
    }

    private void sendHelpLinkClickedEvent(String eventId) {
        ComponentAccessor.getComponentSafely(HealthCheckAnalyticsSender.class).ifPresent(sender -> sender.sendHelpLinkClicked(eventId));
    }

    private Optional<String> getEventId(HttpServletRequest request) {
        String[] eventIds = request.getParameterValues("eventId");
        if (eventIds == null || eventIds.length != 1) {
            return Optional.empty();
        }
        return Optional.of(eventIds[0]);
    }

    private Optional<String> getKBUrlClicked(HttpServletRequest request) {
        String[] eventIds = request.getParameterValues("kbUrl");
        if (eventIds == null || eventIds.length != 1) {
            return Optional.empty();
        }
        return Optional.of(eventIds[0]);
    }
}

