/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.earlystartup.DeferredAnalyticsEventService;
import com.atlassian.jira.health.DefaultHealthCheckExecutor;
import com.atlassian.jira.health.FileCopyService;
import com.atlassian.jira.health.ModificationsManager;
import com.atlassian.jira.health.ModificationsMigrationService;
import com.atlassian.jira.health.analytics.HeliumCopyFilesAnalyticsEvent;
import com.atlassian.jira.health.checks.CustomisedConfigurationsHealthCheck;
import com.atlassian.jira.health.web.JohnsonTemplateContext;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class JohnsonConfigMigrationServlet
extends HttpServlet {
    public static final Logger LOG = LoggerFactory.getLogger(JohnsonConfigMigrationServlet.class);
    private JiraAuthenticationContext jiraAuthenticationContext;
    private ModificationsMigrationService modificationsMigrationService;
    private ModificationsManager modificationsManager;
    private FileCopyService fileCopyService;
    private JiraJohnsonContainer johnsonContainer;
    private DeferredAnalyticsEventService deferredAnalyticsEventService;

    public void init() {
        this.johnsonContainer = ((JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class)).getContainer();
        this.modificationsManager = (ModificationsManager)ComponentAccessor.getComponent(ModificationsManager.class);
        this.fileCopyService = (FileCopyService)ComponentAccessor.getComponent(FileCopyService.class);
        this.modificationsMigrationService = (ModificationsMigrationService)ComponentAccessor.getComponent(ModificationsMigrationService.class);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        this.deferredAnalyticsEventService = (DeferredAnalyticsEventService)ComponentAccessor.getComponent(DeferredAnalyticsEventService.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ComponentAccessor.getComponentSafely(GlobalPermissionManager.class).isPresent()) {
            response.sendError(500, "Jira has not started correctly, copy cannot be performed");
        } else if (this.isAdministrator()) {
            Optional<Event> eventOptional = this.findAutoMigrateJohnsonEvent();
            if (eventOptional.isPresent()) {
                Set<Path> savedModificationsFromModificationsFolder = this.modificationsManager.getSavedModificationsFromModificationsFolder();
                Set<Path> filesNotPossibleToCopy = this.modificationsMigrationService.checkCopyingNotPossible(savedModificationsFromModificationsFolder);
                Sets.SetView filesToTryToCopy = Sets.difference(savedModificationsFromModificationsFolder, filesNotPossibleToCopy);
                Set<FileCopyService.CopyFailure> uncopiedFiles = this.fileCopyService.copyFiles((Collection<Path>)filesToTryToCopy);
                this.removeAutoMigrateJohnsonEvent(eventOptional.get());
                if (!uncopiedFiles.isEmpty() || !filesNotPossibleToCopy.isEmpty()) {
                    this.addConfigCustomisationEvent((Set<Path>)Sets.union(uncopiedFiles.stream().map(FileCopyService.CopyFailure::getRelativeFilePath).collect(Collectors.toSet()), filesNotPossibleToCopy));
                } else {
                    this.addCopySuccessEvent(filesToTryToCopy.size());
                }
                this.deferredAnalyticsEventService.publish(new HeliumCopyFilesAnalyticsEvent(filesToTryToCopy.size(), filesNotPossibleToCopy.size(), Sets.difference((Set)filesToTryToCopy, uncopiedFiles).size(), uncopiedFiles.size(), uncopiedFiles));
            }
            response.sendRedirect(request.getContextPath() + Johnson.getConfig().getErrorPath());
        } else if (this.notLoggedIn()) {
            String loginUrl = new UrlBuilder(RedirectUtils.getLoginUrl((HttpServletRequest)request)).asUrlString();
            response.sendRedirect(loginUrl);
        } else {
            response.sendRedirect(request.getContextPath() + Johnson.getConfig().getErrorPath() + "#no-admin");
        }
    }

    private void addCopySuccessEvent(int numberOfFilesCopied) {
        Event event = new Event(JohnsonEventType.UPGRADE.eventType(), "Config customisations copied successfully", null, JohnsonEventLevel.WARNING.eventLevel());
        event.addAttribute((Object)"dismissible", (Object)false);
        event.addAttribute((Object)"templateContext", (Object)new SuccessTemplateContext(numberOfFilesCopied));
        DefaultHealthCheckExecutor.addEventAttributes(event, "configuration-changes", "copy-success-event", Optional.empty());
        this.johnsonContainer.addEvent(event);
    }

    private void addConfigCustomisationEvent(Set<Path> modifiedFiles) {
        Event event = CustomisedConfigurationsHealthCheck.createEvent(Collections.emptySet(), modifiedFiles, "Some files failed to be copied", false);
        DefaultHealthCheckExecutor.addEventAttributes(event, "configuration-changes", "post-copy-changes", Optional.of(CustomisedConfigurationsHealthCheck.KB_URL));
        this.johnsonContainer.addEvent(event);
    }

    private boolean notLoggedIn() {
        return this.jiraAuthenticationContext.getLoggedInUser() == null;
    }

    private boolean isAdministrator() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return ComponentAccessor.getComponentSafely(GlobalPermissionManager.class).map(globalPermissionManager -> globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)).orElse(false);
    }

    private void removeAutoMigrateJohnsonEvent(Event event) {
        this.johnsonContainer.removeEvent(event);
    }

    private Optional<Event> findAutoMigrateJohnsonEvent() {
        return this.johnsonContainer.getEvents().stream().filter(event -> event.getKey().equals((Object)JohnsonEventType.UPGRADE.eventType())).findFirst();
    }

    public static class SuccessTemplateContext
    implements JohnsonTemplateContext {
        private final String type = "configCustomisationSuccess";
        private final int numberOfFilesCopied;

        public SuccessTemplateContext(int numberOfFilesCopied) {
            this.numberOfFilesCopied = numberOfFilesCopied;
        }

        @Override
        public String getType() {
            return "configCustomisationSuccess";
        }

        public int getNumberOfFilesCopied() {
            return this.numberOfFilesCopied;
        }
    }
}

