/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsSender;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventPredicates;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class JohnsonDismissEventsServlet
extends HttpServlet {
    private static final String MY_JIRA_HOME = "/secure/MyJiraHome.jspa";
    private JohnsonEventContainer johnsonContainer;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private HealthCheckAnalyticsSender healthCheckAnalyticsSender;

    public void init() {
        this.johnsonContainer = Johnson.getEventContainer((ServletContext)this.getServletContext());
        this.jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.healthCheckAnalyticsSender = (HealthCheckAnalyticsSender)ComponentAccessor.getComponent(HealthCheckAnalyticsSender.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getRequestURI().endsWith("/events/dismiss")) {
            if (this.canDismissEvents()) {
                this.dismissEvents();
                response.sendRedirect(request.getContextPath() + MY_JIRA_HOME);
            } else if (this.notLoggedIn()) {
                String loginUrl = new UrlBuilder(RedirectUtils.getLoginUrl((HttpServletRequest)request)).asUrlString();
                response.sendRedirect(loginUrl);
            } else {
                response.sendRedirect(request.getContextPath() + Johnson.getConfig().getErrorPath() + "#no-admin");
            }
        } else {
            response.setStatus(404);
        }
    }

    private boolean notLoggedIn() {
        return this.jiraAuthenticationContext.getLoggedInUser() == null;
    }

    private boolean canDismissEvents() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return ComponentAccessor.getComponentSafely(GlobalPermissionManager.class).map(globalPermissionManager -> globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)).orElse(false);
    }

    private void dismissEvents() {
        this.johnsonContainer.stream().filter(EventPredicates.attributeEquals((String)"dismissible", (Object)true)).forEach(e -> {
            this.healthCheckAnalyticsSender.sendHealthCheckDismissed((Event)e);
            this.johnsonContainer.removeEvent(e);
        });
    }
}

