/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.servlet.AvatarToStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewUniversalAvatarServletImpl {
    private static final Logger log = LoggerFactory.getLogger(ViewUniversalAvatarServletImpl.class);
    public static final String AVATAR_ID_PARAM = "avatarId";
    public static final String AVATAR_TYPE_PARAM = "avatarType";
    public static final String AVATAR_SIZE_PARAM = "size";
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarToStream avatarToStream;
    private final AvatarManager avatarManager;
    private final FeatureManager featureManager;

    public ViewUniversalAvatarServletImpl(JiraAuthenticationContext authenticationContext, AvatarToStream avatarToStream, AvatarManager avatarManager, FeatureManager featureManager) {
        this.authenticationContext = authenticationContext;
        this.avatarToStream = avatarToStream;
        this.avatarManager = avatarManager;
        this.featureManager = featureManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            PreprocessAvatar preprocessAvatar = this.getAvatar(request);
            Avatar.Size size = this.getValidAvatarSize(request);
            this.avatarToStream.sendAvatar(new AvatarToStream.AvatarData(preprocessAvatar.getAvatar(), size, preprocessAvatar.getCachePolicy()), request, response);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(404, iae.getMessage());
        }
    }

    @Nonnull
    private PreprocessAvatar getAvatar(HttpServletRequest request) {
        AvatarToStream.CachePolicies cachePolicy = AvatarToStream.CachePolicies.YEARS_1;
        ApplicationUser user = this.authenticationContext.getUser();
        long avatarId = this.getValidAvatarId(request);
        IconType iconType = this.getValidAvatarType(request);
        Avatar avatar = this.avatarManager.getById(Long.valueOf(avatarId));
        if (avatar != null) {
            if (!avatar.getIconType().equals((Object)iconType)) {
                throw new IllegalArgumentException("No icon with ID=" + avatarId + " for type=" + iconType);
            }
            boolean userCanViewAvatar = this.avatarManager.userCanView(user, avatar);
            if (!userCanViewAvatar) {
                avatar = null;
            }
            if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.RETURN_DEFAULT_AVATARS_FOR_BROKEN_AVATARS) && avatar != null && !this.avatarManager.hasImage(avatar, this.getValidAvatarSize(request))) {
                log.debug("Unable to obtain avatar data for avatar {}/{}. Using default avatar.", (Object)avatarId, (Object)iconType);
                avatar = null;
                cachePolicy = AvatarToStream.CachePolicies.DAYS_1;
            }
        }
        if (null == avatar) {
            avatar = this.avatarManager.getDefaultAvatar(iconType);
        }
        return new PreprocessAvatar(avatar, cachePolicy);
    }

    private long getValidAvatarId(HttpServletRequest request) {
        String avatarIdSpec = request.getParameter(AVATAR_ID_PARAM);
        if (null == avatarIdSpec) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM);
        }
        try {
            return Long.valueOf(avatarIdSpec);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM, x);
        }
    }

    private IconType getValidAvatarType(HttpServletRequest request) {
        String avatarTypeSpec = request.getParameter(AVATAR_TYPE_PARAM);
        IconType iconType = IconType.of((String)avatarTypeSpec);
        if (null == iconType) {
            throw new IllegalArgumentException(AVATAR_TYPE_PARAM);
        }
        return iconType;
    }

    private Avatar.Size getValidAvatarSize(HttpServletRequest request) {
        String avatarSizeSpec = request.getParameter(AVATAR_SIZE_PARAM);
        if (null == avatarSizeSpec) {
            return Avatar.Size.defaultSize();
        }
        try {
            return Avatar.Size.getSizeFromParam((String)avatarSizeSpec);
        }
        catch (NoSuchElementException x) {
            throw new IllegalArgumentException(AVATAR_SIZE_PARAM, x);
        }
    }

    private static class PreprocessAvatar {
        final Avatar avatar;
        final AvatarToStream.CachePolicies cachePolicy;

        private PreprocessAvatar(@Nonnull Avatar avatar, @Nullable AvatarToStream.CachePolicies cachePolicy) {
            this.avatar = avatar;
            this.cachePolicy = cachePolicy != null ? cachePolicy : AvatarToStream.CachePolicies.YEARS_1;
        }

        @Nonnull
        public Avatar getAvatar() {
            return this.avatar;
        }

        @Nonnull
        public AvatarToStream.CachePolicies getCachePolicy() {
            return this.cachePolicy;
        }
    }
}

