/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.viewfile;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.DefaultTemporaryWebAttachmentManager;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.CommonAttachment;
import com.atlassian.jira.web.servlet.CommonAttachmentImpl;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.viewfile.ViewAttachmentServlet;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

@UnrestrictedAccess
public class ViewTemporaryAttachmentServlet
extends ViewAttachmentServlet {
    public static final String URL_REGEX = "/?([a-zA-Z0-9]+)/([a-zA-Z0-9]+?)_(.+)";
    public static final Pattern URL_PATTERN = Pattern.compile("/?([a-zA-Z0-9]+)/([a-zA-Z0-9]+?)_(.+)");
    private final AttachmentManager attachmentManager = ComponentAccessor.getAttachmentManager();
    private final DefaultTemporaryWebAttachmentManager temporaryWebAttachmentManager = (DefaultTemporaryWebAttachmentManager)ComponentAccessor.getComponent(DefaultTemporaryWebAttachmentManager.class);

    @Override
    protected int getContentLength(String attachmentPath) {
        TemporaryWebAttachment attachment = this.getTemporaryAttachment(attachmentPath);
        return (int)attachment.getSize();
    }

    @Override
    protected void getInputStream(HttpServletRequest request, String attachmentQuery, InputStreamConsumer<Unit> consumer) throws PermissionException {
        ParsedQuery parsedQuery = this.parseAttachmentQuery(attachmentQuery);
        if (!this.temporaryWebAttachmentManager.canGetTemporaryWebAttachment(parsedQuery.attachmentId, this.getLoggedInUser())) {
            throw new PermissionException("Cannot access temporary attachment - missing permissions");
        }
        this.attachmentManager.streamTemporaryAttachmentContent(TemporaryAttachmentId.fromString((String)parsedQuery.attachmentId), consumer);
    }

    @VisibleForTesting
    protected ParsedQuery parseAttachmentQuery(String attachmentQuery) {
        Matcher matcher = URL_PATTERN.matcher(attachmentQuery);
        if (matcher.matches()) {
            String formToken = matcher.group(1);
            String attachmentId = matcher.group(2);
            String filename = matcher.group(3);
            return new ParsedQuery(formToken, attachmentId, filename);
        }
        throw new InvalidAttachmentPathException();
    }

    private TemporaryWebAttachment getTemporaryAttachment(String query) {
        ParsedQuery parsedQuery = this.parseAttachmentQuery(query);
        Optional<TemporaryWebAttachment> temporaryAttachment = this.temporaryWebAttachmentManager.getTemporaryWebAttachmentsByFormToken(parsedQuery.formToken).stream().filter(attachment -> Objects.equals(attachment.getStringId(), parsedQuery.attachmentId)).findAny();
        return temporaryAttachment.orElseThrow(() -> new AttachmentNotFoundException((Object)parsedQuery.attachmentId));
    }

    @Override
    protected CommonAttachment getCommonAttachment(String query) {
        TemporaryWebAttachment attachment = this.getTemporaryAttachment(query);
        return new CommonAttachmentImpl(attachment.getFilename(), attachment.getContentType(), (int)attachment.getSize());
    }

    public class ParsedQuery {
        final String formToken;
        final String attachmentId;
        final String filename;

        public ParsedQuery(String formToken, String attachmentId, String filename) {
            this.formToken = formToken;
            this.attachmentId = attachmentId;
            this.filename = filename;
        }

        public String getFormToken() {
            return this.formToken;
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

