/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.viewfile;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.viewfile.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.viewfile.RangeResponse;
import io.atlassian.fugue.Unit;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ViewThumbnailServlet
extends AbstractViewFileServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewThumbnailServlet.class);
    private final Supplier<ThumbnailAccessor> thumbnailAccessorSupplier = () -> (ThumbnailAccessor)ComponentAccessor.getComponent(ThumbnailAccessor.class);

    @Override
    protected int getContentLength(String attachmentPath) {
        Attachment attachment = this.getAttachment(attachmentPath);
        FileStore.Path thumbnailPath = this.thumbnailAccessorSupplier.get().getThumbnailFilePath(attachment);
        return (int)this.getContentLength(thumbnailPath);
    }

    private long getContentLength(FileStore.Path attachmentPath) {
        try {
            return attachmentPath.getFileSize().getBytes();
        }
        catch (IOException e) {
            log.debug("Exception getting thumbnail content size", (Throwable)e);
            return 0L;
        }
    }

    @Override
    protected boolean supportsRangeRequests() {
        return false;
    }

    @Override
    protected void getInputStream(HttpServletRequest request, String attachmentPath, InputStreamConsumer<Unit> consumer) throws IOException, PermissionException {
        Attachment attachment = this.getAttachment(attachmentPath);
        this.checkRequesterIsPermittedToViewTheAttachment(attachment, request, "You do not have permissions to view this attachment");
        ((ThumbnailManager)ComponentAccessor.getComponentOfType(ThumbnailManager.class)).streamThumbnailContent(attachment, consumer);
    }

    @Override
    protected void setResponseContentHeaders(HttpServletRequest request, Optional<RangeResponse> rangeResponse, HttpServletResponse response, Optional<Long> contentLength) {
        Attachment attachment = this.getAttachment(this.attachmentQuery(request));
        FileStore.Path thumbnailPath = this.thumbnailAccessorSupplier.get().getThumbnailFilePath(attachment);
        response.setContentType(ThumbnailManager.MIME_TYPE.toString());
        response.setContentLengthLong(contentLength.orElseGet(() -> this.getContentLength(thumbnailPath)).longValue());
        response.setHeader("Content-Disposition", "inline; filename=" + thumbnailPath.getLeafName().orElse("unknown") + ";");
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }
}

