/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.web.session.cluster.SessionInvalidationReplicatedEvent;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

@EventComponent
public class JiraUserSessionInvalidator {
    private static final Logger LOG = LoggerFactory.getLogger(JiraUserSessionInvalidator.class);
    private final JiraUserSessionTracker jiraUserSessionTracker = JiraUserSessionTracker.getInstance();
    private final RememberMeTokenDao rememberMeTokenDao = (RememberMeTokenDao)ComponentAccessor.getComponent(RememberMeTokenDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleSessionInvalidation(HttpServletRequest request) {
        String sessionId;
        block6: {
            HttpSession session;
            block5: {
                sessionId = null;
                session = request.getSession(false);
                if (session != null) break block5;
                if (!StringUtils.isNotEmpty(sessionId)) return;
                this.jiraUserSessionTracker.removeInvalidateFlagFromSession(sessionId);
                return;
            }
            try {
                sessionId = session.getId();
                if (!this.jiraUserSessionTracker.isSessionMarkedForInvalidation(sessionId)) break block6;
                session.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    LOG.debug("Can't handle invalidation of session.", (Throwable)illegalStateException);
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isNotEmpty(sessionId)) throw throwable;
                    this.jiraUserSessionTracker.removeInvalidateFlagFromSession(sessionId);
                    throw throwable;
                }
                if (!StringUtils.isNotEmpty(sessionId)) return;
                this.jiraUserSessionTracker.removeInvalidateFlagFromSession(sessionId);
                return;
            }
        }
        if (!StringUtils.isNotEmpty((CharSequence)sessionId)) return;
        this.jiraUserSessionTracker.removeInvalidateFlagFromSession(sessionId);
        return;
    }

    public void invalidateSession(String sessionId) {
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return;
        }
        this.jiraUserSessionTracker.markSessionAsInvalid(sessionId);
    }

    public void removeInvalidationFlagFromSession(HttpServletRequest httpServletRequest) {
        HttpSession session;
        if (httpServletRequest != null && (session = httpServletRequest.getSession(false)) != null) {
            this.jiraUserSessionTracker.removeInvalidateFlagFromSession(session.getId());
        }
    }

    private void invalidateAllSessionsForUser(String username) {
        String currentSessionId = this.getSessionId(ActionContext.getRequest());
        this.jiraUserSessionTracker.getSnapshot().stream().filter(activeSession -> StringUtils.equals((CharSequence)activeSession.getUserName(), (CharSequence)username)).filter(activeSession -> !StringUtils.equals((CharSequence)activeSession.getId(), (CharSequence)currentSessionId)).map(JiraUserSession::getId).forEach(this::invalidateSession);
        this.rememberMeTokenDao.removeAllForUser(username);
    }

    private String getSessionId(HttpServletRequest request) {
        HttpSession session;
        if (request != null && (session = request.getSession(false)) != null) {
            return session.getId();
        }
        return null;
    }

    @EventListener
    public void onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        this.invalidateAllSessionsForUser(event.getUsername());
    }

    @EventListener
    public void onUserAnonymizationFinishedEvent(UserAnonymizationFinishedEvent anonymizationEvent) {
        this.invalidateAllSessionsForUser(anonymizationEvent.getOldUserName());
    }

    @EventListener
    public void onSessionInvalidationReplicatedEvent(SessionInvalidationReplicatedEvent sessionInvalidationReplicatedEvent) {
        this.invalidateAllSessionsForUser(sessionInvalidationReplicatedEvent.getUsername());
    }
}

