/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.ui.model;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ui.model.DropDownModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DropDownModelBuilder {
    private List<DropDownModel.DropDownSection> sections = new ArrayList<DropDownModel.DropDownSection>();
    private String topText = null;
    private DropDownSectionImpl currentSection = null;

    public static DropDownModelBuilder builder() {
        return new DropDownModelBuilder();
    }

    public DropDownModelBuilder setTopText(String topText) {
        this.topText = topText;
        return this;
    }

    public DropDownModelBuilder startSection() {
        if (this.currentSection != null) {
            throw new IllegalStateException("You are currently in a section");
        }
        this.currentSection = new DropDownSectionImpl();
        return this;
    }

    public DropDownModelBuilder endSection() {
        if (this.currentSection == null) {
            throw new IllegalStateException("You are NOT currently in a section");
        }
        this.sections.add(this.currentSection);
        this.currentSection = null;
        return this;
    }

    public DropDownModelBuilder addItem(DropDownItemImpl item) {
        if (this.currentSection == null) {
            throw new IllegalStateException("You are currently NOT in a section");
        }
        this.currentSection.add((DropDownItemImpl)Assertions.notNull((String)"item", (Object)item));
        return this;
    }

    public DropDownItemImpl item() {
        return new DropDownItemImpl();
    }

    public DropDownModel build() {
        if (this.currentSection != null) {
            throw new IllegalStateException("You are currently in a section");
        }
        return new DropDownModelImpl(this.topText, this.sections);
    }

    private class DropDownSectionImpl
    implements DropDownModel.DropDownSection {
        private List<DropDownModel.DropDownItem> items = new ArrayList<DropDownModel.DropDownItem>();

        private DropDownSectionImpl() {
        }

        private void add(DropDownItemImpl item) {
            this.items.add(item);
        }

        @Override
        public List<DropDownModel.DropDownItem> getItems() {
            return this.items;
        }
    }

    public static class DropDownItemImpl
    implements DropDownModel.DropDownItem {
        private String itemText = "";
        private Map<String, String> attrs = new HashMap<String, String>();

        @Override
        public String getText() {
            return this.itemText;
        }

        @Override
        public String getAttr(String name) {
            return this.attrs.get(name);
        }

        @Override
        public String getAttrAndRemove(String name) {
            String value = this.attrs.get(name);
            this.attrs.remove(name);
            return value;
        }

        @Override
        public Set<String> getAttrs() {
            return this.attrs.keySet();
        }

        public DropDownItemImpl setText(String itemText) {
            this.itemText = itemText;
            return this;
        }

        public DropDownItemImpl setAttr(String attrName, String attrValue) {
            this.attrs.put(attrName, attrValue);
            return this;
        }
    }

    private class DropDownModelImpl
    implements DropDownModel {
        private final String topText;
        private final List<DropDownModel.DropDownSection> sections;

        private DropDownModelImpl(String topText, List<DropDownModel.DropDownSection> sections) {
            this.topText = topText;
            this.sections = sections;
        }

        @Override
        public String getTopText() {
            return this.topText;
        }

        @Override
        public List<DropDownModel.DropDownSection> getSections() {
            return this.sections;
        }

        @Override
        public int getTotalItems() {
            int count = 0;
            for (DropDownModel.DropDownSection section : this.sections) {
                count += section.getItems().size();
            }
            return count;
        }
    }
}

