/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeHistoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeHistoryUtils.class);
    public static final String CHANGED_FROM = "] changed from [";
    public static final String TO = "] to [";
    public static final String SET_TO = "] set to [";
    public static final String WAS_ADDED = "] was added";
    public static final String WAS_REMOVED = "] was removed";
    public static final String LINE_ENDING = "]";
    public static final String TERMINATOR = "\n";
    public static final String TERMINATOR_BR = "<br>\n";

    public static String highlight(String body, String colour) {
        String htmlBody = TextUtils.plainTextToHtml((String)body);
        StringTokenizer st = new StringTokenizer(htmlBody, TERMINATOR);
        StringBuilder buff = new StringBuilder(htmlBody.length());
        while (st.hasMoreTokens()) {
            buff.append(ChangeHistoryUtils.highlightLine(st.nextToken() + TERMINATOR, colour));
        }
        return TextUtils.closeTags((String)buff.toString());
    }

    public static String highlightLine(String line, String colour) {
        int firstCloseBracket;
        boolean terminatorBr = false;
        if (((String)line).endsWith(TERMINATOR_BR)) {
            line = ((String)line).substring(0, ((String)line).length() - 5);
            terminatorBr = true;
        } else {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (((String)line).length() > 0 && ((String)line).charAt(0) == '[' && (firstCloseBracket = ((String)line).indexOf(93)) > 0 && firstCloseBracket < 15 && ((String)line).charAt(firstCloseBracket + 1) == ' ') {
            line = "[<font color=" + colour + ">" + ((String)line).substring(1, firstCloseBracket) + "</font>" + ((String)line).substring(firstCloseBracket);
        }
        int changedFrom = ((String)line).indexOf(CHANGED_FROM);
        int to = ((String)line).indexOf(TO);
        if (changedFrom > 0 || to > 0) {
            if (changedFrom > 0) {
                line = ((String)line).substring(0, changedFrom) + "] changed from [<font color=" + colour + ">" + ((String)line).substring(changedFrom + CHANGED_FROM.length());
                to = ((String)line).indexOf(TO);
            }
            if (to > 0) {
                line = ((String)line).substring(0, to) + "</font>] to [<font color=" + colour + ">" + ((String)line).substring(to + TO.length());
            }
        } else {
            int secondBracket;
            int setTo = ((String)line).indexOf(SET_TO);
            if (setTo > 0) {
                line = ((String)line).substring(0, setTo) + "] set to [<font color=" + colour + ">" + ((String)line).substring(setTo + SET_TO.length());
            } else if (((String)line).endsWith(WAS_ADDED)) {
                int secondBracket2 = ((String)line).indexOf(91, ((String)line).indexOf(91) + 1);
                if (secondBracket2 > 0) {
                    line = ((String)line).substring(0, secondBracket2 + 1) + "<font color=" + colour + ">" + ((String)line).substring(secondBracket2 + 1, ((String)line).lastIndexOf(WAS_ADDED)) + "</font>] was added";
                }
            } else if (((String)line).endsWith(WAS_REMOVED) && (secondBracket = ((String)line).indexOf(91, ((String)line).indexOf(91) + 1)) > 0) {
                line = ((String)line).substring(0, secondBracket + 1) + "<font color=" + colour + ">" + ((String)line).substring(secondBracket + 1, ((String)line).lastIndexOf(WAS_REMOVED)) + "</font>] was removed";
            }
        }
        if (((String)line).endsWith(LINE_ENDING)) {
            line = ((String)line).substring(0, ((String)line).length() - LINE_ENDING.length()) + "</font>]";
        }
        line = terminatorBr ? (String)line + TERMINATOR_BR : (String)line + TERMINATOR;
        return line;
    }
}

