/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LimitedOutputStream;
import com.atlassian.jira.util.PathTraversalException;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.atlassian.jira.web.util.WebAttachmentManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.multipart.MultiPartRequestWrapper;

public class DefaultWebAttachmentManager
implements WebAttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebAttachmentManager.class);
    private final AttachmentConfigStore attachmentConfigStore;
    private final AttachmentConfigManager attachmentConfigManager;
    private final AttachmentManager attachmentManager;
    private final AttachmentService attachmentService;
    private final FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil;
    private final I18nHelper.BeanFactory beanFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final TemporaryAttachmentsMonitorLocator locator;
    private final IssueFactory issueFactory;

    public DefaultWebAttachmentManager(AttachmentManager attachmentManager, I18nHelper.BeanFactory beanFactory, JiraAuthenticationContext authenticationContext, TemporaryAttachmentsMonitorLocator locator, AttachmentService attachmentService, AttachmentConfigStore attachmentConfigStore, AttachmentConfigManager attachmentConfigManager, IssueFactory issueFactory) {
        this.attachmentManager = attachmentManager;
        this.beanFactory = beanFactory;
        this.authenticationContext = authenticationContext;
        this.locator = locator;
        this.attachmentService = attachmentService;
        this.attachmentConfigStore = attachmentConfigStore;
        this.attachmentConfigManager = attachmentConfigManager;
        this.fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
        this.issueFactory = Objects.requireNonNull(issueFactory);
    }

    @Override
    public ChangeItemBean createAttachment(MultiPartRequestWrapper requestWrapper, ApplicationUser remoteUser, Issue issue, String fileParamName, Map<String, Object> attachmentProperties) throws AttachmentException {
        return this.createAttachment(requestWrapper, remoteUser, issue.getGenericValue(), fileParamName, attachmentProperties);
    }

    @Override
    public ChangeItemBean createAttachment(MultiPartRequestWrapper requestWrapper, ApplicationUser remoteUser, GenericValue issue, String fileParamName, Map<String, Object> attachmentProperties) throws AttachmentException {
        File file = requestWrapper.getFile(fileParamName);
        if (file == null) {
            log.warn(String.format("Could not create attachment. No file found in MultiPartRequestWrapper. File param name: %s. Request wrapper file names: %s.", fileParamName, CollectionBuilder.list((Object[])new Enumeration[]{requestWrapper.getFileNames()})));
            return null;
        }
        String filename = requestWrapper.getFilesystemName(fileParamName);
        if (filename == null) {
            log.warn("Cannot create attachment without a filename - inline content? See https://jira.atlassian.com/browse/JRA-10825 (file={}).", (Object)file.getName());
            return null;
        }
        String contentType = requestWrapper.getContentType(fileParamName);
        CreateAttachmentParamsBean createAttachmentParamsBean = new CreateAttachmentParamsBean.Builder(file, filename, contentType, remoteUser, (Issue)this.issueFactory.getIssue(issue)).attachmentProperties(attachmentProperties).createdTime((Date)UtilDateTime.nowTimestamp()).build();
        return this.attachmentManager.createAttachment(createAttachmentParamsBean);
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(MultiPartRequestWrapper requestWrapper, String fileParamName, Issue issue, Project project, String formToken) throws AttachmentException {
        if (issue == null && project == null) {
            throw new IllegalArgumentException("'issue' and 'project' cannot be null at the same time.");
        }
        this.validateAttachmentIfExists(requestWrapper, fileParamName, false);
        File file = requestWrapper.getFile(fileParamName);
        if (file == null) {
            log.warn(String.format("Could not create attachment. No file found in MultiPartRequestWrapper. File param name: %s. Request wrapper file names: %s.", fileParamName, CollectionBuilder.list((Object[])new Enumeration[]{requestWrapper.getFileNames()})));
            return null;
        }
        this.assertCanAttach(issue, project);
        String filename = requestWrapper.getFilesystemName(fileParamName);
        String contentType = requestWrapper.getContentType(fileParamName);
        try {
            UniqueFile uniqueFile = this.createUniqueFile(file.getName());
            this.createTemporaryAttachmentOnDisk(file, uniqueFile.getFile());
            TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), uniqueFile.getFile(), filename, contentType, formToken);
            this.addToMonitor(temporaryAttachment);
            return temporaryAttachment;
        }
        catch (IOException e) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.io.error", fileParamName, e.getMessage()), (Throwable)e);
        }
        catch (PathTraversalException e) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.io.error", fileParamName, e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(MultiPartRequestWrapper requestWrapper, String fileParamName, Issue issue, Project project) throws AttachmentException {
        return this.createTemporaryAttachment(requestWrapper, fileParamName, issue, project, this.getFormToken(issue, project));
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(InputStream stream, String fileName, String contentType, long size, Issue issue, Project project, String formToken) throws AttachmentException {
        Assertions.notBlank((String)"fileName", (String)fileName);
        Assertions.notBlank((String)"contentType", (String)contentType);
        Assertions.notNull((String)"stream", (Object)stream);
        if (issue == null && project == null) {
            throw new IllegalArgumentException("'issue' and 'project' cannot be null at the same time.");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size must be >= 0.");
        }
        if (size == 0L) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
        }
        long maxAttachmentSize = this.getMaxAttachmentSize();
        if (size > maxAttachmentSize) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)maxAttachmentSize)));
        }
        this.assertCanAttach(issue, project);
        this.assertFileNameIsValid(fileName);
        UniqueFile uniqueFile = null;
        LimitedOutputStream limitedOutput = null;
        try {
            uniqueFile = this.createUniqueFile(fileName);
            FileOutputStream fos = new FileOutputStream(uniqueFile.getFile());
            limitedOutput = this.wrapOutputStream(fos, size);
            IOUtils.copy((InputStream)stream, (OutputStream)limitedOutput);
            limitedOutput.close();
            if (limitedOutput.getCurrentLength() != size) {
                DefaultWebAttachmentManager.deleteFileIfExists(uniqueFile.getFile());
                String text = limitedOutput.getCurrentLength() == 0L ? this.getI18n().getText("attachfile.error.io.bad.size.zero", fileName) : this.getI18n().getText("attachfile.error.io.bad.size", fileName, String.valueOf(limitedOutput.getCurrentLength()), String.valueOf(size));
                throw new AttachmentException(text);
            }
            TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), uniqueFile.getFile(), fileName, contentType, formToken);
            this.addToMonitor(temporaryAttachment);
            return temporaryAttachment;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(limitedOutput);
            if (uniqueFile != null) {
                DefaultWebAttachmentManager.deleteFileIfExists(uniqueFile.getFile());
            }
            if (e instanceof LimitedOutputStream.TooBigIOException) {
                LimitedOutputStream.TooBigIOException tooBigIOException = (LimitedOutputStream.TooBigIOException)e;
                throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)tooBigIOException.getNextSize())));
            }
            log.debug("I/O error occured while attaching file.", (Throwable)e);
            throw new AttachmentException(this.getI18n().getText("attachfile.error.io.error", fileName, e.getMessage()), (Throwable)e);
        }
        catch (PathTraversalException e) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.io.error", fileName, e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(InputStream stream, String fileName, String contentType, long size, Issue issue, Project project) throws AttachmentException {
        return this.createTemporaryAttachment(stream, fileName, contentType, size, issue, project, this.getFormToken(issue, project));
    }

    @Override
    public boolean validateAttachmentIfExists(MultiPartRequestWrapper requestWrapper, String fileParamName, boolean required) throws AttachmentException {
        File file = requestWrapper.getFile(fileParamName);
        String filename = requestWrapper.getFilesystemName(fileParamName);
        String contentType = requestWrapper.getContentType(fileParamName);
        return StringUtils.isNotBlank((CharSequence)contentType) && this.assertAttachmentIfExists(file, filename, required, requestWrapper.getContentLength());
    }

    private static void deleteFileIfExists(File file) {
        if (file.exists() && !file.delete()) {
            log.warn("Unable to delete file '" + file + "'.");
        }
    }

    void addToMonitor(TemporaryAttachment temporaryAttachment) throws AttachmentException {
        TemporaryAttachmentsMonitor attachmentsMonitor = this.locator.get(true);
        if (attachmentsMonitor == null) {
            DefaultWebAttachmentManager.deleteFileIfExists(temporaryAttachment.getFile());
            throw new AttachmentException(this.getI18n().getText("attachfile.error.session.error", temporaryAttachment.getFilename()));
        }
        attachmentsMonitor.add(temporaryAttachment);
    }

    private void createTemporaryAttachmentOnDisk(File file, File targetFile) throws AttachmentException {
        try {
            FileUtils.moveFile((File)file, (File)targetFile);
        }
        catch (IOException e) {
            String message = this.getI18n().getText("attachfile.error.save.to.store", (Object)e);
            log.error(message, (Throwable)e);
            throw new AttachmentException(message);
        }
    }

    LimitedOutputStream wrapOutputStream(OutputStream fos, long size) {
        return new LimitedOutputStream(new BufferedOutputStream(fos), size);
    }

    void assertFileNameIsValid(String filename) throws AttachmentException {
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.no.name"));
        }
        String invalidChar = this.fileNameCharacterCheckerUtil.assertFileNameDoesNotContainInvalidChars(filename);
        if (invalidChar != null) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.invalidcharacter", filename, invalidChar));
        }
    }

    boolean assertAttachmentIfExists(File file, String fileName, boolean required, int contentLength) throws AttachmentException {
        boolean exists = this.exists(file, fileName, contentLength);
        if (!exists) {
            if (required) {
                throw new AttachmentException(this.getI18n().getText("attachfile.error.filerequired"));
            }
        } else {
            this.assertFileNameIsValid(fileName);
        }
        return exists;
    }

    private boolean exists(File file, String fileName, int contentLength) throws AttachmentException {
        if (file == null) {
            if (fileName != null) {
                long attachmentSize = this.getMaxAttachmentSize();
                if ((long)contentLength > attachmentSize) {
                    throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)attachmentSize)));
                }
                throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
            }
            return false;
        }
        if (file.length() == 0L) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
        }
        return true;
    }

    private long getUUID() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    UniqueFile createUniqueFile(String fileName) throws IOException, PathTraversalException {
        long uniqueId;
        File tempAttachmentFile;
        File tmpDir = this.attachmentConfigManager.getTemporaryAttachmentDirectory();
        while ((tempAttachmentFile = new File(tmpDir, (uniqueId = this.getUUID()) + "_" + fileName)).exists()) {
        }
        PathUtils.ensurePathInSecureDir((String)tmpDir.getCanonicalPath(), (String)tempAttachmentFile.getCanonicalPath());
        return new UniqueFile(tempAttachmentFile, uniqueId);
    }

    long getMaxAttachmentSize() {
        return this.attachmentConfigStore.getConfig().getMaxAttachmentSize();
    }

    I18nHelper getI18n() {
        return this.beanFactory.getInstance(this.authenticationContext.getLocale());
    }

    String getFormToken(Issue issue, Project project) {
        Either entity = Eithers.cond((issue == null ? 1 : 0) != 0, (Object)issue, (Object)project);
        return TemporaryAttachment.getEntityToken((Either)entity);
    }

    void assertCanAttach(Issue issue, Project project) throws AttachmentException {
        if (issue == null) {
            JiraServiceContext context = this.createServiceContext();
            this.attachmentService.canCreateAttachments(context, project);
            DefaultWebAttachmentManager.throwForFirstError(context.getErrorCollection());
        } else {
            JiraServiceContext context = this.createServiceContext();
            this.attachmentService.canCreateTemporaryAttachments(context, issue);
            DefaultWebAttachmentManager.throwForFirstError(context.getErrorCollection());
        }
    }

    private JiraServiceContext createServiceContext() {
        return new JiraServiceContextImpl(this.authenticationContext.getUser(), (ErrorCollection)new SimpleErrorCollection(), this.authenticationContext.getI18nHelper());
    }

    private static void throwForFirstError(ErrorCollection collection) throws AttachmentException {
        if (collection.hasAnyErrors()) {
            String message = (String)DefaultWebAttachmentManager.getFirstElement(collection.getErrorMessages());
            if (message == null) {
                message = (String)DefaultWebAttachmentManager.getFirstElement(collection.getErrors().values());
            }
            throw new AttachmentException(message);
        }
    }

    private static <T> T getFirstElement(Collection<? extends T> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    static class UniqueFile {
        private final File file;
        private final long id;

        UniqueFile(File file, long id) {
            this.file = file;
            this.id = id;
        }

        public File getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }
    }
}

