/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.GMTOffsetConverter;
import com.atlassian.jira.timezone.TimeZoneResolver;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.TimeZone;

public class UserTimeZoneDataProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final TimeZoneResolver timeZoneResolver;

    public UserTimeZoneDataProvider(JiraAuthenticationContext jiraAuthenticationContext, TimeZoneResolver timeZoneResolver) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.timeZoneResolver = timeZoneResolver;
    }

    public Jsonable get() {
        return writer -> {
            try {
                TimeZone timeZone = this.timeZoneResolver.getUserTimeZone((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser()));
                new JSONObject((Map)ImmutableMap.builder().put((Object)"offset", (Object)GMTOffsetConverter.GMT_OFFSET_CONVERTER.apply(timeZone)).build()).write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }
}

