/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.jira.workflow.SkippableCondition;
import com.atlassian.jira.workflow.SkippableValidator;
import com.google.common.collect.ImmutableList;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOSWorkflowConfigurator
implements Startable,
OSWorkflowConfigurator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOSWorkflowConfigurator.class);
    private static final List<String> CLASS_NAME_PREFIX_WHITELIST = ImmutableList.of((Object)"com.atlassian.");
    @ClusterSafe
    private final ConcurrentMap<String, TypeResolver> pluginTypeResolvers = new ConcurrentHashMap<String, TypeResolver>();
    private final TypeResolver legacyTypeResolver;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    public DefaultOSWorkflowConfigurator(EventPublisher eventPublisher, FeatureManager featureManager) {
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.legacyTypeResolver = new LegacyJiraTypeResolver();
    }

    public void start() throws Exception {
        TypeResolver.setResolver((TypeResolver)new JiraTypeResolverDelegator());
    }

    @Override
    public void registerTypeResolver(String className, TypeResolver typeResolver) {
        Assertions.notNull((String)"className", (Object)className);
        Assertions.notNull((String)"typeResolver", (Object)typeResolver);
        this.pluginTypeResolvers.put(className, typeResolver);
    }

    @Override
    public void unregisterTypeResolver(String className, TypeResolver typeResolver) {
        Assertions.notNull((String)"className", (Object)className);
        Assertions.notNull((String)"typeResolver", (Object)typeResolver);
        this.pluginTypeResolvers.remove(className, typeResolver);
    }

    final class LegacyJiraTypeResolver
    extends TypeResolver {
        public LegacyJiraTypeResolver() {
            this.conditions = Collections.emptyMap();
            this.functions = Collections.emptyMap();
            this.registers = Collections.emptyMap();
            this.validators = Collections.emptyMap();
        }

        protected Object loadObject(String className) {
            String trimmedClassName = className.trim();
            try {
                Class objClass = ClassLoaderUtils.loadClass((String)trimmedClassName, ((Object)((Object)this)).getClass());
                if (objClass == null) {
                    log.error("Could not load class '" + trimmedClassName + "'");
                    DefaultOSWorkflowConfigurator.this.eventPublisher.publish((Object)ClassLoadedAnalyticsEvent.allowedClass(trimmedClassName, false));
                    return null;
                }
                if (this.isRestricted(trimmedClassName)) {
                    log.error("Rejecting usage of unsafe workflow function/class: `{}`. You can enable usage of this class by adding `{}.enabled` dark feature flag to Jira. Do it only if you are sure its known and secure case. It will make Jira vulnerablefor potential attacks.", (Object)trimmedClassName, (Object)JiraFeatureFlagRegistrar.WARN_ONLY_ON_UNSAFE_WORKFLOW_CLASS.featureKey());
                    DefaultOSWorkflowConfigurator.this.eventPublisher.publish((Object)ClassLoadedAnalyticsEvent.blockedClass(trimmedClassName));
                    return null;
                }
                DefaultOSWorkflowConfigurator.this.eventPublisher.publish((Object)ClassLoadedAnalyticsEvent.allowedClass(objClass.getName(), true));
                return ComponentManager.getInstance().loadComponent(objClass, Collections.emptyList());
            }
            catch (Exception e) {
                log.error("Could not load class '" + trimmedClassName + "'", (Throwable)e);
                DefaultOSWorkflowConfigurator.this.eventPublisher.publish((Object)ClassLoadedAnalyticsEvent.allowedClass(trimmedClassName, false));
                return null;
            }
        }

        private boolean isRestricted(String className) {
            if (CLASS_NAME_PREFIX_WHITELIST.stream().noneMatch(className::startsWith)) {
                if (DefaultOSWorkflowConfigurator.this.featureManager.isEnabled(JiraFeatureFlagRegistrar.WARN_ONLY_ON_UNSAFE_WORKFLOW_CLASS)) {
                    log.warn("Allowing usage of unsafe workflow function/class `{}.enabled` because `{}` dark feature flag is enabled.", (Object)className, (Object)JiraFeatureFlagRegistrar.WARN_ONLY_ON_UNSAFE_WORKFLOW_CLASS.featureKey());
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    final class JiraTypeResolverDelegator
    extends TypeResolver {
        JiraTypeResolverDelegator() {
        }

        private TypeResolver getDelegate(Map args) {
            String className = (String)args.get("class.name");
            if (className == null) {
                return null;
            }
            TypeResolver typeResolver = (TypeResolver)DefaultOSWorkflowConfigurator.this.pluginTypeResolvers.get(className);
            if (typeResolver == null) {
                return DefaultOSWorkflowConfigurator.this.legacyTypeResolver;
            }
            return typeResolver;
        }

        public Condition getCondition(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return SkippableCondition.of(delegate.getCondition(type, args));
        }

        public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return delegate.getFunction(type, args);
        }

        public Register getRegister(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return delegate.getRegister(type, args);
        }

        public Validator getValidator(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return SkippableValidator.of(delegate.getValidator(type, args));
        }
    }

    @EventName(value="administration.workflow.configurator.legacy.class.loaded")
    static class ClassLoadedAnalyticsEvent {
        private final boolean isAtlassianImplemented;
        private final boolean isOSWorkflowDefault;
        private final boolean isLoadedSuccessfully;
        private final boolean isClassLoadingBlocked;

        public static ClassLoadedAnalyticsEvent allowedClass(String className, boolean isLoadedSuccessfully) {
            return new ClassLoadedAnalyticsEvent(className, isLoadedSuccessfully, false);
        }

        public static ClassLoadedAnalyticsEvent blockedClass(String className) {
            return new ClassLoadedAnalyticsEvent(className, false, true);
        }

        public ClassLoadedAnalyticsEvent(String className, boolean isLoadedSuccessfully, boolean isClassLoadingBlocked) {
            this.isAtlassianImplemented = className.startsWith("com.atlassian.");
            this.isOSWorkflowDefault = className.startsWith("com.opensymphony.workflow.");
            this.isLoadedSuccessfully = isLoadedSuccessfully;
            this.isClassLoadingBlocked = isClassLoadingBlocked;
        }

        public boolean isOSWorkflowDefault() {
            return this.isOSWorkflowDefault;
        }

        public boolean isAtlassianImplemented() {
            return this.isAtlassianImplemented;
        }

        public boolean isLoadedSuccessfully() {
            return this.isLoadedSuccessfully;
        }

        public boolean isClassLoadingBlocked() {
            return this.isClassLoadingBlocked;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassLoadedAnalyticsEvent that = (ClassLoadedAnalyticsEvent)o;
            return this.isAtlassianImplemented == that.isAtlassianImplemented && this.isOSWorkflowDefault == that.isOSWorkflowDefault && this.isLoadedSuccessfully == that.isLoadedSuccessfully && this.isClassLoadingBlocked == that.isClassLoadingBlocked;
        }

        public int hashCode() {
            return Objects.hash(this.isAtlassianImplemented, this.isOSWorkflowDefault, this.isLoadedSuccessfully, this.isClassLoadingBlocked);
        }
    }
}

