/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowPropertyEditor;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class DefaultWorkflowPropertyEditor
implements WorkflowPropertyEditor {
    private final WorkflowService service;
    private final JiraAuthenticationContext context;
    private final JiraWorkflow workflow;
    private final WorkflowOperation operation;
    private Map<String, String> properties;
    private String nameKey;
    private String valueKey;

    @VisibleForTesting
    DefaultWorkflowPropertyEditor(WorkflowService service, JiraAuthenticationContext context, JiraWorkflow workflow, WorkflowOperation operation) {
        this.service = service;
        this.context = context;
        this.workflow = workflow;
        this.operation = operation;
        this.properties = Maps.newHashMap(operation.get());
    }

    @Override
    public ServiceOutcome<WorkflowPropertyEditor.Result> addProperty(String name, String property) {
        return this.executeUpdate(name, property, true);
    }

    @Override
    public ServiceOutcome<WorkflowPropertyEditor.Result> updateProperty(String name, String property) {
        return this.executeUpdate(name, property, false);
    }

    @Override
    public ServiceOutcome<WorkflowPropertyEditor.Result> deleteProperty(String name) {
        Errors errors;
        String key = DefaultWorkflowPropertyEditor.normaliseKey(name);
        if (this.validateDelete(key, errors = new Errors(this.context))) {
            boolean containsKey = this.properties.containsKey(key);
            this.properties.remove(key);
            this.operation.set(Maps.newHashMap(this.properties));
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.service.updateWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.context.getUser(), (ErrorCollection)errorCollection), this.workflow);
            if (errorCollection.hasAnyErrors()) {
                return ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
            }
            return ServiceOutcomeImpl.ok(new SimpleResult(key, null, containsKey));
        }
        return errors.toOutcome(null);
    }

    private ServiceOutcome<WorkflowPropertyEditor.Result> executeUpdate(String name, String property, boolean validateDuplicate) {
        Errors errors;
        String value;
        String key = DefaultWorkflowPropertyEditor.normaliseKey(name);
        if (this.validateUpdate(validateDuplicate, key, value = DefaultWorkflowPropertyEditor.normaliseValue(property), errors = new Errors(this.context))) {
            String oldValue = this.properties.put(key, value);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.operation.set(Maps.newHashMap(this.properties));
            this.service.updateWorkflow((JiraServiceContext)new JiraServiceContextImpl(this.context.getUser(), (ErrorCollection)errorCollection), this.workflow);
            if (errorCollection.hasAnyErrors()) {
                return ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
            }
            return ServiceOutcomeImpl.ok(new SimpleResult(key, value, !value.equals(oldValue)));
        }
        return errors.toOutcome(null);
    }

    @Override
    public WorkflowPropertyEditor nameKey(String nameKey) {
        this.nameKey = StringUtils.stripToNull((String)nameKey);
        return this;
    }

    @Override
    public WorkflowPropertyEditor valueKey(String valueKey) {
        this.valueKey = StringUtils.stripToNull((String)valueKey);
        return this;
    }

    @Override
    public String getNameKey() {
        return this.nameKey == null ? "key" : this.nameKey;
    }

    @Override
    public String getValueKey() {
        return this.valueKey == null ? "value" : this.valueKey;
    }

    private boolean validateUpdate(boolean validateDuplicate, String key, String value, Errors errors) {
        boolean validate = true;
        if (key == null) {
            errors.addError(this.getNameKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.attribute.key.must.be.set", new Object[0]);
            validate = false;
        } else if (WorkflowUtil.isReservedKey((String)key)) {
            errors.addError(this.getNameKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.attribute.key.has.reserved.prefix", "'jira.'");
            validate = false;
        } else if (validateDuplicate && this.properties.containsKey(key)) {
            errors.addError(this.getNameKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.attribute.key.exists", "'" + key + "'");
            validate = false;
        } else if (!this.checkInvalidCharacters(this.getNameKey(), key, errors)) {
            validate = false;
        }
        if (value == null) {
            errors.addError(this.getValueKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.null.value", new Object[0]);
            validate = false;
        } else if (!this.checkInvalidCharacters(this.getValueKey(), value, errors)) {
            validate = false;
        }
        return validate;
    }

    private boolean validateDelete(String key, Errors errors) {
        boolean validate = true;
        if ((key = DefaultWorkflowPropertyEditor.normaliseKey(key)) == null) {
            errors.addError(this.getNameKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.attribute.key.must.be.set", new Object[0]);
            validate = false;
        } else if (WorkflowUtil.isReservedKey((String)key)) {
            errors.addError(this.getNameKey(), ErrorCollection.Reason.VALIDATION_FAILED, "admin.errors.workflows.cannot.remove.reserved.attribute", new Object[0]);
            validate = false;
        }
        return validate;
    }

    private static String normaliseKey(String key) {
        return StringUtils.stripToNull((String)key);
    }

    private static String normaliseValue(String property) {
        if (property == null) {
            return null;
        }
        return StringUtils.stripToEmpty((String)property);
    }

    private boolean checkInvalidCharacters(String fieldKey, String fieldValue, Errors errors) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        WorkflowUtil.checkInvalidCharacters((String)fieldValue, (String)fieldKey, (ErrorCollection)errorCollection);
        errors.addErrorCollection((ErrorCollection)errorCollection);
        return !errorCollection.hasAnyErrors();
    }

    static interface WorkflowOperation {
        public Map<String, String> get();

        public void set(Map<String, String> var1);
    }

    private static class Errors {
        private final ErrorCollection errors = new SimpleErrorCollection();
        private final JiraAuthenticationContext context;

        private Errors(JiraAuthenticationContext context) {
            this.context = context;
        }

        private Errors addError(String key, ErrorCollection.Reason reason, String tr, Object ... args) {
            this.errors.addError(key, this.context.getI18nHelper().getText(tr, (Object)args));
            this.errors.addReason(reason);
            return this;
        }

        private Errors addErrorCollection(ErrorCollection collection) {
            this.errors.addErrorCollection(collection);
            return this;
        }

        private <T> ServiceOutcome<T> toOutcome(T value) {
            return ServiceOutcomeImpl.from(this.errors, value);
        }
    }

    private static class SimpleResult
    implements WorkflowPropertyEditor.Result {
        private final boolean modified;
        private final String name;
        private final String value;

        private SimpleResult(String name, String value, boolean modified) {
            this.value = value;
            this.name = name;
            this.modified = modified;
        }

        @Override
        public boolean isModified() {
            return this.modified;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static class DefaultWorkflowPropertyEditorFactory
    implements WorkflowPropertyEditor.WorkflowPropertyEditorFactory {
        private final WorkflowService service;
        private final JiraAuthenticationContext context;

        public DefaultWorkflowPropertyEditorFactory(JiraAuthenticationContext context, WorkflowService service) {
            this.context = context;
            this.service = service;
        }

        @Override
        public WorkflowPropertyEditor transitionPropertyEditor(JiraWorkflow workflow, final ActionDescriptor descriptor) {
            return new DefaultWorkflowPropertyEditor(this.service, this.context, workflow, new WorkflowOperation(){

                @Override
                public Map<String, String> get() {
                    return descriptor.getMetaAttributes();
                }

                @Override
                public void set(Map<String, String> properties) {
                    descriptor.setMetaAttributes(properties);
                }
            });
        }

        @Override
        public WorkflowPropertyEditor stepPropertyEditor(JiraWorkflow workflow, final StepDescriptor descriptor) {
            return new DefaultWorkflowPropertyEditor(this.service, this.context, workflow, new WorkflowOperation(){

                @Override
                public Map<String, String> get() {
                    return descriptor.getMetaAttributes();
                }

                @Override
                public void set(Map<String, String> properties) {
                    descriptor.setMetaAttributes(properties);
                }
            });
        }
    }
}

