/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.TransitionOptions;
import com.atlassian.jira.workflow.edit.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import com.atlassian.jira.workflow.edit.utilities.ScreenNameResolver;
import com.atlassian.jira.workflow.edit.utilities.WorkflowFunctionUtilities;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workflow
implements JiraWorkflow {
    public static final Supplier<Map<Integer, FunctionDescriptor>> NO_ADDITIONAL_POSTFUNCTIONS = () -> Collections.emptyMap();
    private static final Logger LOG = LoggerFactory.getLogger(Workflow.class);
    private static final Function<StepDescriptor, Integer> GET_STEP_ID = step -> step.getId();
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraWorkflow jiraWorkflow;
    private final WorkflowFunctionUtilities workflowFunctionUtilities;
    private final TransitionOptions transitionOptions;
    private final OutcomeHelper outcomeHelper;
    private final ScreenNameResolver screenNameResolver;

    public Workflow(JiraWorkflow workflow, WorkflowFunctionUtilities workflowFunctionUtilities, JiraAuthenticationContext jiraAuthenticationContext, TransitionOptions transitionOptions, OutcomeHelper outcomeHelper, ScreenNameResolver screenNameResolver) {
        this.jiraWorkflow = workflow;
        this.workflowFunctionUtilities = workflowFunctionUtilities;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.transitionOptions = transitionOptions;
        this.outcomeHelper = outcomeHelper;
        this.screenNameResolver = screenNameResolver;
    }

    public int getId() {
        return this.jiraWorkflow.getDescriptor().getId();
    }

    public Collection<ActionDescriptor> getActionsByName(String name) {
        return this.jiraWorkflow.getActionsByName(name);
    }

    public String getLinkedStatusId(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getLinkedStatusId(stepDescriptor);
    }

    public Set<String> getLinkedStatusIds() {
        return this.jiraWorkflow.getLinkedStatusIds();
    }

    public ServiceOutcome<Workflow> addStatus(Status status) {
        try {
            StepDescriptor step = this.makeStepDescriptor(status);
            this.jiraWorkflow.getDescriptor().addStep(step);
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("addStatus - exception occurred when adding status", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.add.status.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> removeStatus(@NotNull Status status) {
        return this.removeStatus(status.getId());
    }

    public ServiceOutcome<Workflow> removeStatus(String statusId) {
        try {
            StepDescriptor stepToDelete = this.findStepInWorkflowWithStatusId(statusId, null);
            this.removeOutboundTransitions(stepToDelete);
            this.removeInboundTransitions(stepToDelete);
            this.jiraWorkflow.removeStep(stepToDelete);
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("removeStatus() - exception removing status", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.remove.status.error", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateStatus(String statusId, String name) {
        try {
            StepDescriptor step = this.findStepInWorkflowWithStatusId(statusId, null);
            step.setName(name);
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("updateStatus() - exception updating status", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.update.status.error", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> addGlobalTransition(AddTransitionParameters params) {
        StepDescriptor targetStep = this.findStepInWorkflowWithStatusId(params.getTargetStatusId(), params.getTargetStepId());
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(params.getDescription(), params.getName(), params.getScreen(), targetStep.getId(), params.getAdditionalPostfunctionsSupplier());
        if (!transitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        try {
            transition.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
            this.jiraWorkflow.getDescriptor().addGlobalAction(transition);
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            return this.outcomeHelper.errorOutcome("workflow.edit.adding.global.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<TransitionData> addGlobalTransitionReturningId(AddTransitionParameters params) {
        StepDescriptor targetStep = this.findStepInWorkflowWithStatusId(params.getTargetStatusId(), params.getTargetStepId());
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(params.getDescription(), params.getName(), params.getScreen(), targetStep.getId(), params.getAdditionalPostfunctionsSupplier());
        if (!transitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        try {
            transition.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
            this.jiraWorkflow.getDescriptor().addGlobalAction(transition);
            ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(transition, false, true, false, this.transitionOptions.getOptionsForAction(transition, this.jiraWorkflow), params.getScreen() != null ? params.getScreen().getName() : null);
            return ServiceOutcomeImpl.ok(data);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return this.outcomeHelper.errorOutcome("workflow.edit.adding.global.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateGlobalTransition(int transitionId, String name, String description, FieldScreen screen) {
        return this.updateTransition(transitionId, name, description, screen);
    }

    public ServiceOutcome<Workflow> addCommonTransition(String sourceStatusId, int transitionId) {
        try {
            StepDescriptor sourceStep = this.findStepInWorkflowWithStatusId(sourceStatusId, null);
            ActionDescriptor transition = this.getDescriptor().getAction(transitionId);
            if (!transition.isCommon()) {
                this.makeTransitionCommon(transition);
            }
            sourceStep.getActions().add(transition);
            sourceStep.getCommonActions().add(transition.getId());
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("Workflow.addCommonTransition failed", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.reusing.a.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<TransitionData> addTransition(AddTransitionParameters params) {
        StepDescriptor sourceStep = this.findStepInWorkflowWithStatusId(params.getSourceStatusId(), params.getSourceStepId());
        StepDescriptor targetStep = this.findStepInWorkflowWithStatusId(params.getTargetStatusId(), params.getTargetStepId());
        ServiceOutcome<ActionDescriptor> addTransitionOutcome = this.addTransitionToWorkflow(params.getDescription(), params.getName(), params.getScreen(), sourceStep, targetStep, params.getAdditionalPostfunctionsSupplier());
        if (!addTransitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(addTransitionOutcome);
        }
        ActionDescriptor actionDescriptor = (ActionDescriptor)addTransitionOutcome.getReturnedValue();
        String screenName = this.screenNameResolver.getScreenName(actionDescriptor);
        ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(actionDescriptor, false, false, false, this.transitionOptions.getOptionsForAction(actionDescriptor, this.jiraWorkflow), screenName);
        return ServiceOutcomeImpl.ok(data);
    }

    public ServiceOutcome<TransitionData> addLoopedTransition(String name, String description, FieldScreen screen) {
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(description, name, screen, -1, NO_ADDITIONAL_POSTFUNCTIONS);
        if (!transitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        try {
            transition.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
            this.jiraWorkflow.getDescriptor().addGlobalAction(transition);
        }
        catch (Exception e) {
            return this.outcomeHelper.errorOutcome("workflow.edit.adding.looped.transition.failed", new Object[0]);
        }
        String screenName = screen == null ? null : screen.getName();
        ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(transition, false, false, true, this.transitionOptions.getOptionsForAction(transition, this.jiraWorkflow), screenName);
        return ServiceOutcomeImpl.ok(data);
    }

    public ServiceOutcome<Workflow> deleteLoopedTransition(int loopedTransitionId) {
        return this.deleteGlobalTransition(String.valueOf(loopedTransitionId));
    }

    public ServiceOutcome<Workflow> updateLoopedTransition(int transitionId, String name, String description, FieldScreen screen) {
        return this.updateTransition(transitionId, name, description, screen);
    }

    public ServiceOutcome<Workflow> deleteTransition(int transitionId, int sourceStepId) {
        ServiceOutcome<ActionDescriptor> actionOutcome = this.findActionDescriptor(transitionId);
        if (!actionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(actionOutcome);
        }
        ActionDescriptor action = (ActionDescriptor)actionOutcome.getReturnedValue();
        if (this.isInitialAction(action)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.cannot.delete.initial.transition", new Object[0]);
        }
        ServiceOutcome<StepDescriptor> sourceStepOutcome = this.findStepDescriptor(sourceStepId);
        if (!sourceStepOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(sourceStepOutcome);
        }
        StepDescriptor sourceStep = (StepDescriptor)sourceStepOutcome.getReturnedValue();
        this.removeActionFromWorkflow(action, sourceStep);
        return ServiceOutcomeImpl.ok(this);
    }

    public ServiceOutcome<Workflow> updateTransition(int transitionId, String name, String description, FieldScreen screen) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            transition.setName(name);
            transition.getMetaAttributes().put("jira.description", description);
            ServiceOutcome<ActionDescriptor> screenResult = this.addScreenToTransition(transition, screen);
            if (!screenResult.isValid()) {
                return this.outcomeHelper.errorOutcome(screenResult.getErrorCollection());
            }
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("updateTransition - there was a problem updating the transition.", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateTransitionTarget(int transitionId, Status targetStatus) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            ResultDescriptor result = transition.getUnconditionalResult();
            result.setStep(this.jiraWorkflow.getLinkedStep(targetStatus).getId());
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("updateTransitionTarget - there was a problem updating the transition target.", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.target.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateTransitionSource(int transitionId, Status newSourceStatus, Status originalSourceStatus) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            StepDescriptor originalSourceStep = this.jiraWorkflow.getLinkedStep(originalSourceStatus);
            StepDescriptor newSourceStep = this.jiraWorkflow.getLinkedStep(newSourceStatus);
            if (transition.isCommon()) {
                originalSourceStep.getCommonActions().remove((Object)transitionId);
                newSourceStep.getCommonActions().add(transitionId);
            } else {
                transition.setParent((AbstractDescriptor)newSourceStep);
            }
            originalSourceStep.getActions().remove(transition);
            newSourceStep.getActions().add(transition);
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("updateTransitionSource - there was a problem updating the transition source.", (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.updating.transition.source.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> deleteGlobalTransition(String globalTransitionId) {
        try {
            ActionDescriptor action = this.jiraWorkflow.getDescriptor().getAction(Integer.valueOf(globalTransitionId).intValue());
            if (this.jiraWorkflow.getDescriptor().getGlobalActions().contains(action)) {
                this.jiraWorkflow.getDescriptor().removeAction(action);
            }
            return ServiceOutcomeImpl.ok(this);
        }
        catch (Exception e) {
            LOG.error("deleteGlobalTransition - statusId:" + globalTransitionId + ", workflow:" + this.jiraWorkflow, (Throwable)e);
            return this.outcomeHelper.errorOutcome("workflow.edit.deleting.global.transition.failed", new Object[0]);
        }
    }

    public boolean isDuplicateGlobalTransitionName(String transitionName) {
        List transitions = this.jiraWorkflow.getDescriptor().getGlobalActions();
        return this.isNameInTransitions(transitionName, transitions);
    }

    public boolean isDuplicateTransitionName(String transitionName, int sourceStepId) {
        StepDescriptor sourceStep = (StepDescriptor)this.findStepDescriptor(sourceStepId).getReturnedValue();
        return this.isDuplicateTransitionName(transitionName, sourceStep);
    }

    public boolean isDuplicateLoopedTransitionName(String transitionName) {
        Collection transitions = this.jiraWorkflow.getAllActions();
        List loopedTransitions = transitions.stream().filter(transition -> transition.getId() == -1 && transition.getName().equals(transitionName)).collect(Collectors.toList());
        return loopedTransitions.size() > 0;
    }

    public boolean targetStatusHasExistingTransitionWithName(int transitionId, String transitionName) {
        int targetStepId = this.jiraWorkflow.getDescriptor().getAction(transitionId).getUnconditionalResult().getStep();
        List matchingTransitions = this.jiraWorkflow.getAllActions().stream().filter(transition -> transition.getUnconditionalResult().getStep() == targetStepId).collect(Collectors.toList());
        return this.isNameInTransitions(transitionName, Lists.newArrayList(matchingTransitions));
    }

    public boolean isCommonTransition(int transitionId) {
        return this.hasTransition(transitionId) && this.jiraWorkflow.getDescriptor().getAction(transitionId).isCommon();
    }

    public boolean commonTransitionExistsFromSource(int transitionId, Status source) {
        boolean commonTransitionExistsFromSource = false;
        ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
        if (transition.isCommon()) {
            StepDescriptor sourceStep = this.getLinkedStep(source);
            commonTransitionExistsFromSource = sourceStep.getActions().contains(transition) && sourceStep.getCommonActions().contains(transitionId);
        }
        return commonTransitionExistsFromSource;
    }

    public boolean hasTransition(int transitionId) {
        return this.jiraWorkflow.getDescriptor().getAction(transitionId) != null;
    }

    public ServiceOutcome<Boolean> statusHasOutgoingTransition(Status status, int transitionId) {
        ServiceOutcome<ActionDescriptor> actionDescriptorOutcome = this.findActionDescriptor(transitionId);
        if (!actionDescriptorOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(actionDescriptorOutcome);
        }
        StepDescriptor statusStep = this.getLinkedStep(status);
        Collection<StepDescriptor> transitionSourceSteps = this.getStepsForTransition((ActionDescriptor)actionDescriptorOutcome.getReturnedValue());
        return ServiceOutcomeImpl.ok(transitionSourceSteps.contains(statusStep));
    }

    public String getTransitionName(int transitionId) {
        return this.jiraWorkflow.getDescriptor().getAction(transitionId).getName();
    }

    public boolean statusHasGlobalTransition(Status status) {
        StepDescriptor step = this.findStepInWorkflowWithStatusId(status.getId(), null);
        List globalTransitions = this.jiraWorkflow.getDescriptor().getGlobalActions();
        for (ActionDescriptor transition : globalTransitions) {
            if (transition.getUnconditionalResult().getStep() != step.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean statusExistsOnWorkflow(Status status) {
        return null != this.findStepInWorkflowWithStatusId(status.getId(), null);
    }

    public List<Integer> getStepIds() {
        return this.getSteps().stream().map(GET_STEP_ID).collect(Collectors.toList());
    }

    private void removeInboundTransitions(StepDescriptor stepToDelete) {
        List matchingTransitions = this.jiraWorkflow.getAllActions().stream().filter(transition -> transition.getUnconditionalResult().getStep() == stepToDelete.getId() || transition.getConditionalResults().stream().anyMatch(crd -> crd.getStep() == stepToDelete.getId())).collect(Collectors.toList());
        for (ActionDescriptor matchedTransition : matchingTransitions) {
            if (this.jiraWorkflow.isGlobalAction(matchedTransition)) {
                this.deleteGlobalTransition(String.valueOf(matchedTransition.getId()));
                continue;
            }
            for (StepDescriptor step : this.getStepsForTransition(matchedTransition)) {
                this.removeActionFromWorkflow(matchedTransition, step);
            }
        }
    }

    private void makeTransitionCommon(ActionDescriptor transition) {
        StepDescriptor originalParent = (StepDescriptor)transition.getParent();
        originalParent.getActions().remove(transition);
        this.getDescriptor().addCommonAction(transition);
        transition.setParent((AbstractDescriptor)this.getDescriptor());
        originalParent.getActions().add(transition);
        originalParent.getCommonActions().add(transition.getId());
    }

    private void removeOutboundTransitions(StepDescriptor stepToDelete) {
        ArrayList transitions = Lists.newArrayList((Iterable)stepToDelete.getActions());
        for (ActionDescriptor transition : transitions) {
            this.removeActionFromWorkflow(transition, stepToDelete);
        }
    }

    private ServiceOutcome<ActionDescriptor> addTransitionToWorkflow(String description, String name, FieldScreen screen, StepDescriptor sourceStep, StepDescriptor targetStep, Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctions) {
        if (this.isDuplicateTransitionName(name, sourceStep)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.transition.name.exists", new Object[0]);
        }
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(description, name, screen, targetStep.getId(), additionalPostfunctions);
        if (!transitionOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        transition.setParent((AbstractDescriptor)sourceStep);
        sourceStep.getActions().add(transition);
        return ServiceOutcomeImpl.ok(transition);
    }

    public boolean isDuplicateTransitionName(String transitionName, StepDescriptor sourceStep) {
        return this.isDuplicateStepTransitionName(transitionName, sourceStep) || this.isDuplicateGlobalTransitionName(transitionName);
    }

    public boolean stepExists(int stepId) {
        return this.jiraWorkflow.getDescriptor().getStep(stepId) != null;
    }

    public boolean stepExists(Status status) {
        StepDescriptor linkedStep = this.jiraWorkflow.getLinkedStep(status);
        return linkedStep != null && this.stepExists(linkedStep.getId());
    }

    private boolean isNameInTransitions(String transitionName, Collection<ActionDescriptor> transitions) {
        for (ActionDescriptor transition : transitions) {
            if (!transitionName.equalsIgnoreCase(transition.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateStepTransitionName(String transitionName, StepDescriptor sourceStep) {
        List transitions = sourceStep.getActions();
        return this.isNameInTransitions(transitionName, transitions);
    }

    private ServiceOutcome<ActionDescriptor> createTransition(String description, String name, FieldScreen fieldScreen, int targetStepId, Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctions) {
        ResultDescriptor transitionResult = DescriptorFactory.getFactory().createResultDescriptor();
        transitionResult.setStep(targetStepId);
        ActionDescriptor transition = DescriptorFactory.getFactory().createActionDescriptor();
        transition.setId(this.jiraWorkflow.getNextActionId());
        transition.setName(name);
        transition.getMetaAttributes().put("jira.description", description);
        transition.setUnconditionalResult(transitionResult);
        this.addDefaultPostFunctionsToTransition(transition, additionalPostfunctions);
        return this.addScreenToTransition(transition, fieldScreen);
    }

    private ServiceOutcome<ActionDescriptor> addScreenToTransition(ActionDescriptor transition, FieldScreen fieldScreen) {
        if (fieldScreen != null) {
            transition.setView("fieldscreen");
            transition.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            transition.setView(null);
            transition.getMetaAttributes().put("jira.fieldscreen.id", null);
        }
        return ServiceOutcomeImpl.ok(transition);
    }

    private ServiceOutcome<ActionDescriptor> findActionDescriptor(int transitionId) {
        ActionDescriptor action = this.jiraWorkflow.getDescriptor().getAction(transitionId);
        if (action == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.transition.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(action);
    }

    private ServiceOutcome<StepDescriptor> findStepDescriptor(int stepId) {
        StepDescriptor step = this.jiraWorkflow.getDescriptor().getStep(stepId);
        if (step == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.selected.status.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(step);
    }

    private void removeActionFromWorkflow(ActionDescriptor action, StepDescriptor sourceStep) {
        sourceStep.getActions().remove(action);
        if (action.isCommon()) {
            sourceStep.getCommonActions().remove((Object)action.getId());
            if (this.jiraWorkflow.getStepsForTransition(action).isEmpty()) {
                this.jiraWorkflow.getDescriptor().getCommonActions().remove(action.getId());
            }
        }
        if (sourceStep.getActions().isEmpty() && sourceStep.getCommonActions().isEmpty()) {
            sourceStep.removeActions();
        }
    }

    private void addDefaultPostFunctionsToTransition(ActionDescriptor transition, Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctions) {
        List transitionPostFunctions = transition.getUnconditionalResult().getPostFunctions();
        for (FunctionDescriptor function : this.workflowFunctionUtilities.getDefaultPostFunctions(additionalPostfunctions)) {
            transitionPostFunctions.add(function);
        }
    }

    public boolean workflowContainsStepWithStatusId(final String statusId) {
        return null != this.findStep(new Predicate<StepDescriptor>(){

            public boolean apply(StepDescriptor input) {
                Object value = input.getMetaAttributes().get("jira.status.id");
                return value instanceof String && statusId.equalsIgnoreCase((String)value);
            }
        });
    }

    private StepDescriptor findStepInWorkflowWithStatusId(final String statusId, final Integer stepId) {
        return this.findStep(new Predicate<StepDescriptor>(){

            public boolean apply(StepDescriptor input) {
                Object value = input.getMetaAttributes().get("jira.status.id");
                return Objects.nonNull(stepId) && input.getId() == stepId.intValue() || Objects.nonNull(statusId) && value instanceof String && statusId.equalsIgnoreCase((String)value);
            }
        });
    }

    private StepDescriptor findStep(Predicate<StepDescriptor> predicate) {
        return (StepDescriptor)Iterables.find(this.getSteps(), predicate, null);
    }

    public List<StepDescriptor> getSteps() {
        return this.jiraWorkflow.getDescriptor().getSteps();
    }

    public String getName() {
        return this.jiraWorkflow.getName();
    }

    public String getDisplayName() {
        return this.jiraWorkflow.getDisplayName();
    }

    public String getDescription() {
        return this.jiraWorkflow.getDescription();
    }

    public WorkflowDescriptor getDescriptor() {
        return this.jiraWorkflow.getDescriptor();
    }

    public Collection<ActionDescriptor> getInitialActions() {
        return this.jiraWorkflow.getDescriptor().getInitialActions();
    }

    public Collection<ActionDescriptor> getGlobalActions() {
        return this.jiraWorkflow.getDescriptor().getGlobalActions();
    }

    public Collection<ActionDescriptor> getAllActions() {
        return this.jiraWorkflow.getAllActions();
    }

    public Collection<ActionDescriptor> getActionsWithResult(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getActionsWithResult(stepDescriptor);
    }

    public boolean removeStep(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.removeStep(stepDescriptor);
    }

    public StepDescriptor getLinkedStep(GenericValue status) {
        return this.jiraWorkflow.getLinkedStep(status);
    }

    public StepDescriptor getLinkedStep(Status status) {
        return this.jiraWorkflow.getLinkedStep(status);
    }

    public List<GenericValue> getLinkedStatuses() {
        return this.jiraWorkflow.getLinkedStatuses();
    }

    public List<Status> getLinkedStatusObjects() {
        return this.jiraWorkflow.getLinkedStatusObjects();
    }

    public boolean isActive() throws WorkflowException {
        return this.jiraWorkflow.isActive();
    }

    public boolean isSystemWorkflow() throws WorkflowException {
        return this.jiraWorkflow.isSystemWorkflow();
    }

    public boolean isEditable() throws WorkflowException {
        return this.jiraWorkflow.isEditable();
    }

    public boolean isDefault() {
        return this.jiraWorkflow.isDefault();
    }

    public boolean isDraftWorkflow() {
        return this.jiraWorkflow.isDraftWorkflow();
    }

    public boolean hasDraftWorkflow() {
        return this.jiraWorkflow.hasDraftWorkflow();
    }

    public int getNextActionId() {
        return this.jiraWorkflow.getNextActionId();
    }

    public Collection<StepDescriptor> getStepsForTransition(ActionDescriptor action) {
        return this.jiraWorkflow.getStepsForTransition(action);
    }

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.getPostFunctionsForTransition(actionDescriptor);
    }

    public boolean isInitialAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isInitialAction(actionDescriptor);
    }

    public boolean isCommonAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isCommonAction(actionDescriptor);
    }

    public boolean isGlobalAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isGlobalAction(actionDescriptor);
    }

    public boolean isOrdinaryAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isOrdinaryAction(actionDescriptor);
    }

    public Status getLinkedStatus(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getLinkedStatus(stepDescriptor);
    }

    @Deprecated
    public Status getLinkedStatusObject(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getLinkedStatus(stepDescriptor);
    }

    public String getActionType(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.getActionType(actionDescriptor);
    }

    public void reset() {
        this.jiraWorkflow.reset();
    }

    public Collection<ActionDescriptor> getActionsForScreen(FieldScreen fieldScreen) {
        return this.jiraWorkflow.getActionsForScreen(fieldScreen);
    }

    public String getUpdateAuthorName() {
        return this.jiraWorkflow.getUpdateAuthorName();
    }

    public ApplicationUser getUpdateAuthor() {
        return this.jiraWorkflow.getUpdateAuthor();
    }

    public Date getUpdatedDate() {
        return this.jiraWorkflow.getUpdatedDate();
    }

    public String getMode() {
        return this.jiraWorkflow.getMode();
    }

    public int compareTo(JiraWorkflow workflow) {
        return this.jiraWorkflow.compareTo((Object)workflow);
    }

    private JiraServiceContextImpl createServiceContext() {
        return new JiraServiceContextImpl(this.getCurrentUser());
    }

    private ApplicationUser getCurrentUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private StepDescriptor makeStepDescriptor(Status status) {
        StepDescriptor step = DescriptorFactory.getFactory().createStepDescriptor();
        step.getMetaAttributes().put("jira.status.id", status.getId());
        step.setId(WorkflowUtil.getNextId(this.getSteps()));
        step.setName(status.getName());
        step.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
        return step;
    }

    public JiraWorkflow getJiraWorkflow() {
        return this.jiraWorkflow;
    }

    public Set<String> getDistinctTransitionNames() {
        TreeSet transitionNames = Sets.newTreeSet((Comparator)new Comparator<String>(){

            @Override
            public int compare(String s, String s2) {
                return s.compareToIgnoreCase(s2);
            }
        });
        for (StepDescriptor stepDescriptor : this.getSteps()) {
            List transitions = stepDescriptor.getActions();
            for (ActionDescriptor transition : transitions) {
                if (transition == null) continue;
                transitionNames.add(transition.getName());
            }
        }
        List transitions = this.getDescriptor().getGlobalActions();
        for (ActionDescriptor actionDescriptor : transitions) {
            if (actionDescriptor == null) continue;
            transitionNames.add(actionDescriptor.getName());
        }
        return transitionNames;
    }

    public static class AddTransitionParameters {
        final String name;
        final String description;
        final String sourceStatusId;
        final String targetStatusId;
        final Integer sourceStepId;
        final Integer targetStepId;
        final FieldScreen screen;
        final Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctionsSupplier;

        private AddTransitionParameters(String name, String description, String sourceStatusId, String targetStatusId, Integer sourceStepId, Integer targetStepId, FieldScreen screen, @Nullable Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctionsSupplier) {
            this.name = name;
            this.description = description;
            this.sourceStatusId = sourceStatusId;
            this.targetStatusId = targetStatusId;
            this.sourceStepId = sourceStepId;
            this.targetStepId = targetStepId;
            this.screen = screen;
            this.additionalPostfunctionsSupplier = Objects.isNull(additionalPostfunctionsSupplier) ? NO_ADDITIONAL_POSTFUNCTIONS : additionalPostfunctionsSupplier;
        }

        public static AddTransitionParametersBuilder builder() {
            return new AddTransitionParametersBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSourceStatusId() {
            return this.sourceStatusId;
        }

        public String getTargetStatusId() {
            return this.targetStatusId;
        }

        public FieldScreen getScreen() {
            return this.screen;
        }

        public Integer getSourceStepId() {
            return this.sourceStepId;
        }

        public Integer getTargetStepId() {
            return this.targetStepId;
        }

        @Nullable
        public Supplier<Map<Integer, FunctionDescriptor>> getAdditionalPostfunctionsSupplier() {
            return this.additionalPostfunctionsSupplier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddTransitionParameters that = (AddTransitionParameters)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.sourceStatusId != null ? !this.sourceStatusId.equals(that.sourceStatusId) : that.sourceStatusId != null) {
                return false;
            }
            if (this.targetStatusId != null ? !this.targetStatusId.equals(that.targetStatusId) : that.targetStatusId != null) {
                return false;
            }
            if (this.sourceStepId != null ? !this.sourceStepId.equals(that.sourceStepId) : that.sourceStepId != null) {
                return false;
            }
            if (this.targetStepId != null ? !this.targetStepId.equals(that.targetStepId) : that.targetStepId != null) {
                return false;
            }
            if (this.screen != null ? !this.screen.equals(that.screen) : that.screen != null) {
                return false;
            }
            return this.additionalPostfunctionsSupplier != null ? this.additionalPostfunctionsSupplier.equals(that.additionalPostfunctionsSupplier) : that.additionalPostfunctionsSupplier == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.sourceStatusId != null ? this.sourceStatusId.hashCode() : 0);
            result = 31 * result + (this.targetStatusId != null ? this.targetStatusId.hashCode() : 0);
            result = 31 * result + (this.sourceStepId != null ? this.sourceStepId.hashCode() : 0);
            result = 31 * result + (this.targetStepId != null ? this.targetStepId.hashCode() : 0);
            result = 31 * result + (this.screen != null ? this.screen.hashCode() : 0);
            result = 31 * result + (this.additionalPostfunctionsSupplier != null ? this.additionalPostfunctionsSupplier.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AddTransitionParameters{name='" + this.name + "', description='" + this.description + "', sourceStatusId='" + this.sourceStatusId + "', targetStatusId='" + this.targetStatusId + "', sourceStepId=" + this.sourceStepId + ", targetStepId=" + this.targetStepId + ", screen=" + this.screen + ", additionalPostfunctionsSupplier=" + this.additionalPostfunctionsSupplier + "}";
        }
    }

    public static class AddTransitionParametersBuilder {
        private String name;
        private String description;
        private String sourceStatusId;
        private String targetStatusId;
        private Integer sourceStepId;
        private Integer targetStepId;
        private FieldScreen screen;
        private Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctionsSupplier;

        public AddTransitionParametersBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AddTransitionParametersBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AddTransitionParametersBuilder sourceStatusId(String statusId) {
            this.sourceStatusId = statusId;
            return this;
        }

        public AddTransitionParametersBuilder sourceStatus(@NotNull Status status) {
            this.sourceStatusId = status.getId();
            return this;
        }

        public AddTransitionParametersBuilder targetStatusId(String statusId) {
            this.targetStatusId = statusId;
            return this;
        }

        public AddTransitionParametersBuilder targetStatus(@NotNull Status status) {
            this.targetStatusId = status.getId();
            return this;
        }

        public AddTransitionParametersBuilder sourceStepId(Integer sourceStepId) {
            this.sourceStepId = sourceStepId;
            return this;
        }

        public AddTransitionParametersBuilder targetStepId(Integer targetStepId) {
            this.targetStepId = targetStepId;
            return this;
        }

        public AddTransitionParametersBuilder screen(FieldScreen screen) {
            this.screen = screen;
            return this;
        }

        public AddTransitionParametersBuilder additionalPostfunctions(Supplier<Map<Integer, FunctionDescriptor>> additionalPostfunctionsSupplier) {
            this.additionalPostfunctionsSupplier = additionalPostfunctionsSupplier;
            return this;
        }

        public AddTransitionParameters build() {
            return new AddTransitionParameters(this.name, this.description, this.sourceStatusId, this.targetStatusId, this.sourceStepId, this.targetStepId, this.screen, this.additionalPostfunctionsSupplier);
        }
    }
}

