/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSWorkflowEntry;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;

public class WorkflowIssueCountValidator {
    private final QueryDslAccessor queryDslAccessor;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public WorkflowIssueCountValidator(QueryDslAccessor queryDslAccessor, JiraAuthenticationContext jiraAuthenticationContext) {
        this.queryDslAccessor = queryDslAccessor;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public ServiceResult validateNoIssuesInStatus(String workflowName, String statusId) {
        boolean issueExists = this.issueInWorkflowAndStatusExist(workflowName, statusId);
        if (issueExists) {
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("admin.workflows.service.error.status.delete.existing.issues", "<strong>", "</strong>", "<br />"));
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private boolean issueInWorkflowAndStatusExist(String workflowName, String statusId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> !((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).join((EntityPath)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY)).on((Predicate)QIssue.ISSUE.workflowId.eq(QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id))).where((Predicate)QIssue.ISSUE.status.eq((Object)statusId).and((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.name.eq((Object)workflowName)))).limit(1L)).fetch().isEmpty());
    }

    private I18nHelper getI18nBean() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }
}

