/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignToLeadFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = LoggerFactory.getLogger(AssignToLeadFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        ApplicationUser lead;
        MutableIssue issue = this.getIssue(transientVars);
        String leadKey = null;
        if (issue.getComponentObjects() != null) {
            leadKey = this.findAComponentLead((Issue)issue);
        }
        if (leadKey == null) {
            lead = issue.getProjectObject().getProjectLead();
            leadKey = lead == null ? null : lead.getKey();
        } else {
            lead = this.getLead(leadKey);
            if (lead == null) {
                log.warn("Component lead '" + leadKey + "' in project " + issue.getProjectObject().getName() + " does not exist");
                return;
            }
        }
        if (leadKey == null) {
            return;
        }
        log.debug("Automatically setting assignee to lead developer " + leadKey);
        issue.setAssignee(lead);
        if (issue.isCreated()) {
            issue.store();
        }
    }

    private String findAComponentLead(Issue issue) {
        for (ProjectComponent component : issue.getComponentObjects()) {
            String leadKey = component.getLead();
            if (leadKey == null) continue;
            return leadKey;
        }
        return null;
    }

    ApplicationUser getLead(String userKey) {
        return ComponentAccessor.getUserManager().getUserByKey(userKey);
    }
}

