/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import java.util.List;
import javax.annotation.Nonnull;

public class DefaultWorkflowSchemeMigrationTaskAccessor
implements WorkflowSchemeMigrationTaskAccessor {
    private final TaskManager taskManager;
    private final WorkflowSchemeManager manager;

    public DefaultWorkflowSchemeMigrationTaskAccessor(TaskManager taskManager, WorkflowSchemeManager manager) {
        this.taskManager = taskManager;
        this.manager = manager;
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActive(@Nonnull Project project) {
        return this.taskManager.getLiveTask(new EnterpriseWorkflowTaskContext(project));
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActiveByProjects(@Nonnull DraftWorkflowScheme scheme, boolean onlyDraftMigrations) {
        return this.getActiveByProjects(scheme, onlyDraftMigrations, false);
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActiveByProjects(@Nonnull DraftWorkflowScheme scheme, boolean onlyDraftMigrations, boolean onlyNonSafeToDelete) {
        List projectsUsing = this.manager.getProjectsUsing(scheme.getParentScheme());
        if (projectsUsing.isEmpty()) {
            return null;
        }
        Project primaryProject = (Project)projectsUsing.get(0);
        TaskDescriptor<WorkflowMigrationResult> task = this.findSchemeMigrationTask(new ProjectMigrationTaskMatcher((WorkflowScheme)scheme, projectsUsing, primaryProject, onlyDraftMigrations, onlyNonSafeToDelete));
        if (task == null) {
            task = this.getActive((WorkflowScheme)scheme.getParentScheme());
        }
        return task;
    }

    @Override
    public TaskDescriptor<WorkflowMigrationResult> getActive(@Nonnull WorkflowScheme scheme) {
        return this.findSchemeMigrationTask(new SchemeMigrationTaskMatcher(scheme));
    }

    public TaskDescriptor<WorkflowMigrationResult> findSchemeMigrationTask(AbstractSchemeMigrationTaskMatcher taskMatcher) {
        return this.taskManager.findFirstTask(taskMatcher);
    }

    static class ProjectMigrationTaskMatcher
    extends AbstractSchemeMigrationTaskMatcher {
        private final EnterpriseWorkflowTaskContext matchContext;
        private final boolean onlyDraftMigrations;
        private final boolean onlyNonSafeToDelete;

        ProjectMigrationTaskMatcher(WorkflowScheme scheme, List<Project> projectsUsing, Project primaryProject, boolean onlyDraftMigrations, boolean onlyNonSafeToDelete) {
            super(scheme);
            this.onlyDraftMigrations = onlyDraftMigrations;
            this.onlyNonSafeToDelete = onlyNonSafeToDelete;
            this.matchContext = new EnterpriseWorkflowTaskContext(primaryProject, projectsUsing, scheme.getId(), true);
        }

        @Override
        boolean match(EnterpriseWorkflowTaskContext that) {
            return !(!this.matchContext.equals(that) || this.onlyDraftMigrations && !that.isDraftMigration() || this.onlyNonSafeToDelete && that.isSafeToDelete());
        }
    }

    private static abstract class AbstractSchemeMigrationTaskMatcher
    implements TaskMatcher {
        protected final WorkflowScheme scheme;

        AbstractSchemeMigrationTaskMatcher(WorkflowScheme scheme) {
            this.scheme = scheme;
        }

        @Override
        public boolean match(TaskDescriptor<?> descriptor) {
            if (descriptor.isFinished()) {
                return false;
            }
            if (!(descriptor.getTaskContext() instanceof EnterpriseWorkflowTaskContext)) {
                return false;
            }
            EnterpriseWorkflowTaskContext that = (EnterpriseWorkflowTaskContext)descriptor.getTaskContext();
            return this.match(that);
        }

        abstract boolean match(EnterpriseWorkflowTaskContext var1);
    }

    static class SchemeMigrationTaskMatcher
    extends AbstractSchemeMigrationTaskMatcher {
        SchemeMigrationTaskMatcher(WorkflowScheme scheme) {
            super(scheme);
        }

        @Override
        boolean match(EnterpriseWorkflowTaskContext that) {
            return this.scheme.getId().equals(that.getSchemeId()) && this.scheme.isDraft() == that.isDraftMigration();
        }
    }
}

