/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResultForMultipleProjects;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AbstractWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.ProjectMigrator;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationCompletedEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;

public class DraftWorkflowSchemeMigrationHelper
extends AbstractWorkflowSchemeMigrationHelper<DraftWorkflowScheme> {
    private final List<Project> projects;
    private final Collection<Long> projectIds;
    private final Project triggerProject;

    DraftWorkflowSchemeMigrationHelper(Project triggerProject, List<Project> projects, DraftWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, ApplicationUser user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager, EventPublisher eventPublisher, IssueConstantFactory issueConstantFactory, QueryDslAccessor queryDslAccessor) throws WorkflowException, GenericEntityException {
        super(targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager, eventPublisher, issueConstantFactory, queryDslAccessor);
        this.triggerProject = triggerProject;
        this.projects = projects;
        this.projectIds = ImmutableList.copyOf((Iterable)Iterables.transform(projects, Project::getId));
        this.calculateInputRequired();
    }

    @Override
    JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        return this.getExistingWorkflowByProjectId(issueTypeId, this.projects.iterator().next().getId());
    }

    @Override
    void quickMigrate() {
        this.workflowSchemeManager.replaceSchemeWithDraft((DraftWorkflowScheme)this.targetScheme);
        this.workflowSchemeManager.clearWorkflowCache();
        this.copyAndDeleteDraftsForInactiveWorkflowsIn((WorkflowScheme)((DraftWorkflowScheme)this.targetScheme).getParentScheme());
    }

    @Override
    BooleanExpression isInCurrentProject(QIssue issue) {
        return this.projectIds.size() < 2000 ? issue.project.in(this.projectIds) : null;
    }

    @Override
    EntityCondition getProjectClause(String projectField) {
        return new EntityExpr(projectField, EntityOperator.IN, this.projectIds);
    }

    @Override
    public WorkflowMigrationResult migrate(TaskProgressSink sink) throws GenericEntityException, WorkflowException {
        if (sink == null) {
            sink = TaskProgressSink.NULL_SINK;
        }
        StatefulTaskProgressSink migrationSink = new StatefulTaskProgressSink(0L, 100L, sink);
        migrationSink.makeProgress(1L, null, this.i18nHelper.getText("admin.selectworkflowscheme.progress.created.target"));
        Iterator<StatefulTaskProgressSink> sinks = StatefulTaskProgressSink.createPercentageSinksForRange(2L, 98L, this.projects.size(), sink).iterator();
        ArrayList projectMigrationResults = Lists.newArrayListWithCapacity((int)this.projects.size());
        boolean atLeastOneWasSuccessful = false;
        AssignableWorkflowScheme intermediateScheme = null;
        if (this.projects.size() > 1) {
            intermediateScheme = this.prepareIntermediateScheme();
            for (Project project : this.projects) {
                DefaultProjectMigrator projectMigrator = new DefaultProjectMigrator(this, project, (WorkflowScheme)intermediateScheme, (ProjectMigrator.OnCompleteCallback)new ProjectMigrator.OnCompleteCallback<AssignableWorkflowScheme>(){

                    @Override
                    public void onComplete(SchemeManager schemeManager, Project project, AssignableWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
                        schemeManager.removeSchemesFromProject(project);
                        schemeManager.addSchemeToProject(project, schemeManager.getSchemeObject(workflowScheme.getId()));
                    }
                });
                if (!this.migrate(sinks, projectMigrationResults, projectMigrator)) continue;
                atLeastOneWasSuccessful = true;
            }
        } else {
            DefaultProjectMigrator projectMigrator = new DefaultProjectMigrator(this, (Project)Iterables.getOnlyElement(this.projects), (WorkflowScheme)((DraftWorkflowScheme)this.targetScheme), (ProjectMigrator.OnCompleteCallback)new ProjectMigrator.OnCompleteCallback<DraftWorkflowScheme>(){

                @Override
                public void onComplete(SchemeManager schemeManager, Project project, DraftWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
                    DraftWorkflowSchemeMigrationHelper.this.taskContext.markSafeToDelete();
                    DraftWorkflowSchemeMigrationHelper.this.workflowSchemeManager.replaceSchemeWithDraft(workflowScheme);
                }
            });
            atLeastOneWasSuccessful = this.migrate(sinks, projectMigrationResults, projectMigrator);
        }
        WorkflowMigrationResultForMultipleProjects result = new WorkflowMigrationResultForMultipleProjects(projectMigrationResults);
        migrationSink.makeProgress(99L, null, this.i18nHelper.getText("admin.selectworkflowscheme.progress.cleanup"));
        if (0 == result.getResult() && result.getNumberOfFailedIssues() == 0 && intermediateScheme != null) {
            this.cleanUpSchemes(intermediateScheme);
        }
        if (atLeastOneWasSuccessful) {
            this.eventPublisher.publish((Object)new WorkflowSchemeMigrationCompletedEvent(this.targetScheme));
        }
        this.workflowSchemeManager.clearWorkflowCache();
        this.copyAndDeleteDraftsForInactiveWorkflowsIn((WorkflowScheme)((DraftWorkflowScheme)this.targetScheme).getParentScheme());
        migrationSink.makeProgress(100L, null, this.i18nHelper.getText("admin.selectworkflowscheme.progress.complete"));
        return result;
    }

    private boolean migrate(Iterator<StatefulTaskProgressSink> sinks, List<WorkflowMigrationResult> projectMigrationResults, ProjectMigrator<?> projectMigrator) throws GenericEntityException {
        WorkflowMigrationResult projectMigrationResult = projectMigrator.migrate(sinks.next(), this.typesNeedingMigration, this.workflowMigrationMapping);
        projectMigrationResults.add(projectMigrationResult);
        return 0 == projectMigrationResult.getResult();
    }

    private AssignableWorkflowScheme prepareIntermediateScheme() {
        String newDescription = this.getIntermediateSchemeDescription();
        return this.workflowSchemeManager.copyDraft((DraftWorkflowScheme)this.targetScheme, this.user, newDescription);
    }

    private String getIntermediateSchemeDescription() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)((DraftWorkflowScheme)this.targetScheme).getDescription())) {
            sb.append(((DraftWorkflowScheme)this.targetScheme).getDescription()).append(" ");
        }
        sb.append(this.i18nHelper.getText("admin.selectworkflowscheme.migration.draft.auto.generated", ((DraftWorkflowScheme)this.targetScheme).getName()));
        return sb.toString();
    }

    private void cleanUpSchemes(AssignableWorkflowScheme intermediateScheme) {
        AssignableWorkflowScheme originalScheme = this.workflowSchemeManager.getParentForDraft(((DraftWorkflowScheme)this.targetScheme).getId().longValue());
        if (!this.workflowSchemeManager.isActive((WorkflowScheme)originalScheme)) {
            this.workflowSchemeManager.deleteWorkflowScheme((WorkflowScheme)originalScheme);
            intermediateScheme = intermediateScheme.builder().setName(originalScheme.getName()).setDescription(originalScheme.getDescription()).build();
            this.workflowSchemeManager.updateWorkflowScheme(intermediateScheme);
        }
    }

    @Override
    protected String getMigrateAsyncTaskDesc() {
        return this.i18nHelper.getText("admin.selectworkflows.publish.draft.task.desc", this.schemeName);
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.triggerProject, this.projects, this.schemeId, true);
    }

    private static class DefaultProjectMigrator<T extends WorkflowScheme>
    extends ProjectMigrator<T> {
        final /* synthetic */ DraftWorkflowSchemeMigrationHelper this$0;

        DefaultProjectMigrator(Project project, T targetScheme, ProjectMigrator.OnCompleteCallback<T> onCompleteCallback) {
            this.this$0 = var1_1;
            super(project, targetScheme, var1_1.workflowManager, var1_1.schemeManager, var1_1.delegator, var1_1.user, var1_1.i18nHelper, ComponentAccessor.getIssueManager(), var1_1.issueIndexManager, onCompleteCallback);
        }
    }
}

