/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.tabs;

import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.tabs.WorkflowTransitionTabProvider;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.api.model.WebPanel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPanelWorkflowTransitionTabProvider
implements WorkflowTransitionTabProvider {
    private static final String TAB_PANELS_LOCATION = "workflow.transition.tabs";
    private static final Logger log = LoggerFactory.getLogger(WebPanelWorkflowTransitionTabProvider.class);
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;

    public WebPanelWorkflowTransitionTabProvider(DynamicWebInterfaceManager dynamicWebInterfaceManager) {
        this.dynamicWebInterfaceManager = (DynamicWebInterfaceManager)Preconditions.checkNotNull((Object)dynamicWebInterfaceManager);
    }

    @Override
    public Iterable<WorkflowTransitionTabProvider.WorkflowTransitionTab> getTabs(ActionDescriptor action, JiraWorkflow workflow) {
        Map<String, Object> context = this.createContext(action, workflow);
        List<? extends WebPanelModuleDescriptor<? extends WebPanel>> panels = this.getDisplayableWebPanelDescriptors(context);
        List<WorkflowTransitionTabProvider.WorkflowTransitionTab> workflowTransitionTabs = panels.stream().map(input -> (WorkflowTransitionTabProvider.WorkflowTransitionTab)SafePluginPointAccess.call(() -> {
            com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor oldWebPanelModuleDescriptor = (com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor)input;
            String label = oldWebPanelModuleDescriptor.getWebLabel().getDisplayableLabel(ExecutingHttpRequest.get(), context);
            String count = this.getCount(context, (WebPanelModuleDescriptor)oldWebPanelModuleDescriptor);
            return new WorkflowTransitionTabProvider.WorkflowTransitionTab(label, count, (WebPanelModuleDescriptor)input);
        }).getOrNull()).filter(Objects::nonNull).toList();
        return ImmutableList.copyOf(workflowTransitionTabs);
    }

    private String getCount(Map<String, Object> context, WebPanelModuleDescriptor webPanelModuleDescriptor) {
        try {
            return webPanelModuleDescriptor.getContextProvider().getContextMap(context).get("count").toString();
        }
        catch (Exception e) {
            log.error("Error getting count for web panel workflow transition tab", (Throwable)e);
            Object count = webPanelModuleDescriptor.getParams().get("count");
            return count != null ? count.toString() : "$count";
        }
    }

    private Map<String, Object> createContext(ActionDescriptor action, JiraWorkflow workflow) {
        ImmutableMap.Builder context = ImmutableMap.builder().putAll(DefaultWebFragmentContext.get((String)TAB_PANELS_LOCATION));
        if (action != null) {
            context.put((Object)"workflow_transition", (Object)action);
        }
        if (workflow != null) {
            context.put((Object)"workflow", (Object)workflow);
        }
        return context.build();
    }

    @Override
    @Nullable
    public String getTabContentHtml(String panelKey, ActionDescriptor action, JiraWorkflow workflow) {
        Map<String, Object> context = this.createContext(action, workflow);
        List<? extends WebPanelModuleDescriptor<? extends WebPanel>> panels = this.getDisplayableWebPanelDescriptors(context);
        Option tabDescriptor = io.atlassian.fugue.Iterables.findFirst(panels, input -> Objects.equals(input.getKey(), panelKey));
        return (String)Iterables.getFirst((Iterable)SafePluginPointAccess.to().descriptors((Iterable)tabDescriptor, (moduleDescriptor, module) -> ((WebPanel)moduleDescriptor.getModule()).getHtml(context)), null);
    }

    private List<? extends WebPanelModuleDescriptor<? extends WebPanel>> getDisplayableWebPanelDescriptors(Map<String, Object> context) {
        return ((List)SafePluginPointAccess.call(() -> this.dynamicWebInterfaceManager.getDisplayableWebPanelDescriptors(TAB_PANELS_LOCATION, context)).getOrElse(Collections.emptyList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

