/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers.jira;

import com.atlassian.jira.service.services.mail.http.MailReader;
import com.atlassian.jira.service.services.mail.http.MailReaderFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import com.atlassian.mail.msgraph.service.ExternalMailPuller;
import com.atlassian.mail.msgraph.settings.dto.MailSettingsDTO;
import com.atlassian.mail.msgraph.settings.providers.MicrosoftOAuthMailConnectionSettingsProvider;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import com.atlassian.mail.server.managers.jira.MailReaderImpl;
import com.atlassian.mail.server.managers.jira.OAuthTokenSupplier;
import java.util.Optional;

public class MailReaderFactoryImpl
implements MailReaderFactory {
    private final OAuthTokenSupplier oAuthTokenSupplier;

    public MailReaderFactoryImpl(OAuthTokenSupplier oAuthTokenSupplier) {
        this.oAuthTokenSupplier = oAuthTokenSupplier;
    }

    public Optional<MailReader> readerFor(MailServer mailServer, String folderName) {
        if (MailProtocol.MS_GRAPH != mailServer.getMailProtocol()) {
            return Optional.empty();
        }
        MailSettingsDTO mailSettingsDTO = new MailSettingsDTO(mailServer.getId().longValue(), mailServer.getUsername(), 0L, mailServer.getTimeout(), folderName);
        JiraMailOAuth2Credentials credentials = MailReaderFactoryImpl.getCredentials((AuthenticationContextAware)mailServer);
        ExternalMailPuller mailPuller = this.getMailPuller(mailSettingsDTO, credentials);
        return Optional.of(new MailReaderImpl(mailPuller));
    }

    private static JiraMailOAuth2Credentials getCredentials(AuthenticationContextAware mailServer) {
        return (JiraMailOAuth2Credentials)mailServer.getAuthenticationContext().getCredentials();
    }

    private ExternalMailPuller getMailPuller(MailSettingsDTO mailSettingsDTO, JiraMailOAuth2Credentials credentials) {
        MicrosoftOAuthMailConnectionSettingsProvider microsoftProvider = new MicrosoftOAuthMailConnectionSettingsProvider(mailSettingsDTO, () -> this.oAuthTokenSupplier.get(credentials.getTokenId()));
        return (ExternalMailPuller)microsoftProvider.getHttpMailClient().get();
    }
}

