/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers.jira;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import io.atlassian.fugue.Option;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthTokenSupplier.class);
    private static final int OAUTH_REFRESH_DURATION_IN_MIN = 5;
    private ClientTokenStorageService clientTokenStorageService;
    private TokenHandler tokenHandler;

    public Option<String> get(String tokenId) {
        Optional token = this.getClientTokenStorageService().getById(tokenId);
        if (token.isPresent()) {
            try {
                ClientToken refreshedToken = this.getTokenHandler().getRefreshedToken(tokenId, Duration.ofMinutes(5L));
                return Option.some((Object)refreshedToken.getAccessToken());
            }
            catch (UnrecoverableTokenException e) {
                LOGGER.warn("OAuth token is unrecoverable - manual re-authorisation required", (Throwable)e);
                return Option.none();
            }
            catch (RecoverableTokenException e) {
                LOGGER.warn("Recoverable exception fetching OAuth token", (Throwable)e);
                return Option.none();
            }
        }
        LOGGER.warn("Token with id {} cannot be found", (Object)tokenId);
        return Option.none();
    }

    private ClientTokenStorageService getClientTokenStorageService() {
        if (this.clientTokenStorageService == null) {
            this.clientTokenStorageService = OAuthTokenSupplier.getOSGiComponent(ClientTokenStorageService.class);
        }
        return this.clientTokenStorageService;
    }

    private TokenHandler getTokenHandler() {
        if (this.tokenHandler == null) {
            this.tokenHandler = OAuthTokenSupplier.getOSGiComponent(TokenHandler.class);
        }
        return this.tokenHandler;
    }

    private static <T> T getOSGiComponent(Class<T> clazz) {
        return (T)ComponentAccessor.getOSGiComponentInstanceOfType(clazz);
    }
}

