/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.velocity.JiraVelocityGlobalMethodAllowlist;
import com.atlassian.velocity.allowlist.api.GlobalMethodAllowlist;
import com.atlassian.velocity.allowlist.api.internal.PluginAllowlist;
import com.atlassian.velocity.allowlist.uberspect.PluginAwareSecureIntrospector;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.Log;
import webwork.action.Action;

public class JiraAllowlistIntrospector
extends PluginAwareSecureIntrospector {
    private volatile JiraAllowlistIntrospectorStatus status = JiraAllowlistIntrospectorStatus.SETUP_NOT_STARTED;
    private final boolean isIntrospectorDisabled;
    private final JiraVelocityMethodsAllowlistResettableLazyRef allowlistedMethodsRef;

    public JiraAllowlistIntrospector(Log log, RuntimeServices runtimeServices) {
        super(log, runtimeServices);
        this.isIntrospectorDisabled = runtimeServices.getConfiguration().getBoolean("jira.secure.introspector.disabled", false);
        String[] methodAllowlistArray = runtimeServices.getConfiguration().getStringArray("introspector.proper.allowlist.methods");
        this.allowlistedMethodsRef = new JiraVelocityMethodsAllowlistResettableLazyRef(() -> {
            Map methodAllowlistMap = this.toMethodSet(methodAllowlistArray);
            return new ConcurrentHashMap(methodAllowlistMap);
        });
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        if (this.status == JiraAllowlistIntrospectorStatus.WAITING_FOR_PLUGIN_SYSTEM) {
            super.onPluginFrameworkStarted(event);
            this.allowlistedMethodsRef.reset();
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_SUCCEEDED);
            this.log.info((Object)"Plugin System has started and the allowlist introspector is ready for its duty!");
        }
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.status == JiraAllowlistIntrospectorStatus.SETUP_SUCCEEDED) {
            this.allowlistedMethodsRef.reset();
        }
    }

    public JiraAllowlistIntrospectorStatus getStatus() {
        return this.status;
    }

    public void resetIntrospectorState() {
        if (ComponentManager.getInstance().getPluginSystemState() != ComponentManager.PluginSystemState.LATE_STARTED) {
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_NOT_STARTED);
        }
    }

    public synchronized void postInitIntrospectorSetup() {
        if (this.isIntrospectorDisabled || this.status == JiraAllowlistIntrospectorStatus.SETUP_SUCCEEDED) {
            return;
        }
        this.log.info((Object)"Starting post init setup for Jira allowlist introspector...");
        this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_IN_PROGRESS);
        Optional pluginAllowlist = ComponentAccessor.getComponentSafely(PluginAllowlist.class);
        if (pluginAllowlist.isEmpty()) {
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_FAILED);
            this.log.error((Object)"No plugin allowlist configured for Jira allowlist introspector.");
            return;
        }
        Optional pluginEventManager = ComponentAccessor.getComponentSafely(PluginEventManager.class);
        if (pluginEventManager.isEmpty()) {
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_FAILED);
            this.log.error((Object)"No plugin event manager configured for Jira allowlist introspector.");
            return;
        }
        Optional globalMethodAllowlist = ComponentAccessor.getComponentSafely(GlobalMethodAllowlist.class);
        if (globalMethodAllowlist.isEmpty()) {
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_FAILED);
            this.log.error((Object)"No global method allowlist configured for Jira allowlist introspector.");
            return;
        }
        this.log.info((Object)"Setting up plugin allowlist...");
        this.setPluginAllowlist((PluginAllowlist)pluginAllowlist.get());
        this.log.info((Object)"Registering introspector as plugin event listener...");
        try {
            ((PluginEventManager)pluginEventManager.get()).register((Object)this);
        }
        catch (Exception e) {
            this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.SETUP_FAILED);
            this.log.error((Object)"Failed to register introspector as plugin event listener.", (Throwable)e);
            return;
        }
        this.log.info((Object)"Setting up introspector for velocity global method allowlist...");
        ((JiraVelocityGlobalMethodAllowlist)globalMethodAllowlist.get()).setIntrospector(this);
        this.setIntrospectorStatus(JiraAllowlistIntrospectorStatus.WAITING_FOR_PLUGIN_SYSTEM);
        this.log.info((Object)"Post init setup for Jira allowlist introspector has been successful but still waiting for the Plugin System to be started.");
    }

    protected boolean isAllowlistedMethodInternal(Method method) {
        Set methodAllowlist = (Set)this.allowlistedMethodsRef.get().get(method.getDeclaringClass());
        return methodAllowlist != null && methodAllowlist.contains(this.makeMethodString(method)) || this.shouldMethodBeAutoAllowlisted(method);
    }

    protected boolean isIntrospectorEnabled() {
        return !this.isIntrospectorDisabled && this.status == JiraAllowlistIntrospectorStatus.SETUP_SUCCEEDED;
    }

    private boolean shouldMethodBeAutoAllowlisted(Method method) {
        return Action.class.isAssignableFrom(method.getDeclaringClass()) && method.getParameterCount() == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is") && Set.of(Boolean.TYPE, Boolean.class).contains(method.getReturnType()));
    }

    private String makeMethodString(Method method) {
        return method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(" ")) + ")";
    }

    private void setIntrospectorStatus(JiraAllowlistIntrospectorStatus status) {
        this.status = status;
    }

    public static enum JiraAllowlistIntrospectorStatus {
        SETUP_NOT_STARTED,
        SETUP_IN_PROGRESS,
        WAITING_FOR_PLUGIN_SYSTEM,
        SETUP_SUCCEEDED,
        SETUP_FAILED;

    }

    private static class JiraVelocityMethodsAllowlistResettableLazyRef
    implements Supplier<ConcurrentMap<Class<?>, Set<String>>> {
        private volatile ConcurrentMap<Class<?>, Set<String>> data;
        protected final Supplier<ConcurrentMap<Class<?>, Set<String>>> supplier;

        public JiraVelocityMethodsAllowlistResettableLazyRef(Supplier<ConcurrentMap<Class<?>, Set<String>>> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConcurrentMap<Class<?>, Set<String>> get() {
            if (this.data == null) {
                JiraVelocityMethodsAllowlistResettableLazyRef jiraVelocityMethodsAllowlistResettableLazyRef = this;
                synchronized (jiraVelocityMethodsAllowlistResettableLazyRef) {
                    if (this.data == null) {
                        this.data = this.supplier.get();
                    }
                }
            }
            return this.data;
        }

        public void reset() {
            this.data = null;
        }
    }
}

