/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.util.Streams;
import com.atlassian.velocity.VelocityTypesUtil;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.velocity.util.introspection.MethodMap;

public class JiraMethodMap
extends MethodMap {
    private final Class<?> clazz;
    private final LoadingCache<String, List<Method>> methodsCache = CacheBuilder.newBuilder().softValues().weakKeys().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Method>>(){

        public List<Method> load(@Nonnull String s) throws Exception {
            return JiraMethodMap.this.loadMethodsForName(s);
        }
    });

    public JiraMethodMap(Class<?> clazz) {
        this.clazz = clazz;
    }

    public List<Method> get(String methodName) {
        if (methodName == null) {
            return Collections.emptyList();
        }
        return (List)this.methodsCache.getUnchecked((Object)methodName);
    }

    public void add(Method method) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Method find(String methodName, Object[] args) throws MethodMap.AmbiguousException {
        Preconditions.checkNotNull((Object)args, (Object)"params cannot not be null");
        Class[] parametersTypes = VelocityTypesUtil.getParametersTypes(args);
        Collection methods = (Collection)this.get(methodName).stream().filter(method -> Arrays.equals(VelocityTypesUtil.getMethodArgsTypes(method), parametersTypes)).collect(CollectorsUtil.toImmutableList());
        if (methods.size() == 1) {
            return (Method)Iterables.getOnlyElement((Iterable)methods);
        }
        if (methods.isEmpty()) {
            return super.find(methodName, args);
        }
        throw new MethodMap.AmbiguousException();
    }

    private List<Method> loadMethodsForName(String methodName) {
        ImmutableSet uniqueMethods = (ImmutableSet)this.getSuperClasses(this.clazz).stream().map(ClassAndAllInterfacesIterator::new).flatMap(iterable -> Streams.stream(iterable)).filter(clazz1 -> Modifier.isPublic(clazz1.getModifiers())).map(clazz1 -> Arrays.asList(clazz1.getDeclaredMethods())).flatMap(Collection::stream).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getName().equals(methodName)).map(MethodComparator::new).collect(CollectorsUtil.toImmutableSet());
        return (List)uniqueMethods.stream().map(m -> m.method).collect(CollectorsUtil.toImmutableList());
    }

    private List<Class<?>> getSuperClasses(Class<?> clazz) {
        ImmutableList.Builder retBuilder = ImmutableList.builder();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            retBuilder.add(current);
        }
        return retBuilder.build();
    }

    private static class MethodComparator {
        private final Method method;

        private MethodComparator(Method method) {
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodComparator that = (MethodComparator)o;
            return this.method.getName().equals(that.method.getName()) && Arrays.equals(this.method.getParameterTypes(), that.method.getParameterTypes());
        }

        public int hashCode() {
            int result = this.method.getName().hashCode();
            result = 31 * result + Arrays.hashCode(this.method.getParameterTypes());
            return result;
        }
    }

    private static class ClassAndAllInterfacesIterator
    implements Iterable<Class<?>> {
        private final Class<?> clazz;

        public ClassAndAllInterfacesIterator(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Iterator<Class<?>> iterator() {
            return new Iterator<Class<?>>(){
                private final Queue<Class<?>> interfacesToVisit;
                {
                    this.interfacesToVisit = Lists.newLinkedList(Collections.singleton(clazz));
                }

                @Override
                public boolean hasNext() {
                    return !this.interfacesToVisit.isEmpty();
                }

                @Override
                public Class<?> next() {
                    Class<?> currentInterface = this.interfacesToVisit.remove();
                    this.interfacesToVisit.addAll(Arrays.asList(currentInterface.getInterfaces()));
                    return currentInterface;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }
}

