/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.velocity.TrackedClasses;
import com.atlassian.velocity.VelocityClassUsageEvent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

final class VelocityClassTracker {
    private final Cache<String, Boolean> published = CacheBuilder.newBuilder().weigher((key, value) -> key.length()).maximumWeight(200000L).build();
    private final EventPublisher publisher;

    VelocityClassTracker(EventPublisher publisher) {
        this.publisher = publisher;
    }

    void track(TrackedClasses classes) {
        classes.filter(className -> this.published.getIfPresent(className) == null).forEach(className -> {
            this.publisher.publish((Object)new VelocityClassUsageEvent((String)className));
            this.published.put(className, (Object)true);
        });
    }
}

