/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.JiraMode;

public class GeneralConfigurationControl
extends BackdoorControl<GeneralConfigurationControl> {
    public GeneralConfigurationControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public GeneralConfigurationControl allowUnassignedIssues() {
        this.setAllowUnassignedIssues(true);
        return this;
    }

    public GeneralConfigurationControl disallowUnassignedIssues() {
        this.setAllowUnassignedIssues(false);
        return this;
    }

    public GeneralConfigurationControl setContactAdminFormOn() {
        this.toggleContactAdminForm(true);
        return this;
    }

    public GeneralConfigurationControl setContactAdminFormOff() {
        this.toggleContactAdminForm(false);
        return this;
    }

    public GeneralConfigurationControl setCaptchaOnSignupOn() {
        this.toggleCaptchaOnSignup(true);
        return this;
    }

    public GeneralConfigurationControl setCaptchaOnSignupOff() {
        this.toggleCaptchaOnSignup(false);
        return this;
    }

    public GeneralConfigurationControl setJiraMode(JiraMode mode) {
        this.createResource().path("applicationProperties/string/set").post((Object)new KeyValueHolder("jira.mode", mode.optionValue()));
        return this;
    }

    public void toggleContactAdminForm(boolean isOn) {
        this.get(this.createResource().path("applicationProperties/option/set").queryParam("key", "jira.show.contact.administrators.form").queryParam("value", Boolean.toString(isOn)));
    }

    public void toggleCaptchaOnSignup(boolean isOn) {
        this.get(this.createResource().path("applicationProperties/option/set").queryParam("key", "jira.option.captcha.on.signup").queryParam("value", Boolean.toString(isOn)));
    }

    public void useGravatars(boolean allow) {
        this.createResource().path("gravatarSettings/allowGravatars").post((Object)allow);
    }

    private void setAllowUnassignedIssues(boolean flag) {
        this.get(this.createResource().path("applicationProperties/option/set").queryParam("key", "jira.option.allowunassigned").queryParam("value", Boolean.toString(flag)));
    }

    private static class KeyValueHolder {
        public String key;
        public String value;

        KeyValueHolder(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

