/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.restclient.Project;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.codehaus.jackson.map.ObjectMapper;

public class JiraHttpClient {
    private final HttpClient httpClient;
    private final String baseUrl;

    public JiraHttpClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.httpClient = new HttpClient();
    }

    public JiraHttpClient loginAs(String namePass) {
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(namePass, namePass));
        return this;
    }

    public String get(String path) {
        GetMethod method = new GetMethod(this.baseUrl + path);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            byte[] responseBody = method.getResponseBody();
            String string = new String(responseBody, Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public JiraHttpClient browseProject(String projectKey) {
        this.get("/browse/" + projectKey);
        return this;
    }

    public List<Project> getRecentProjectsViaRestAPI(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        String projectsJSON = this.get("/rest/api/2/project?recent=" + count);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return Arrays.asList((Object[])mapper.readValue(projectsJSON, Project[].class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

