/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Screen;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class ScreensControl
extends BackdoorControl<ScreensControl> {
    public ScreensControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<Screen> getAllScreens() {
        return (List)this.createResource().get((GenericType)new GenericType<List<Screen>>(){});
    }

    public Screen getScreen(String screenIdOrName) {
        return (Screen)this.createResource().queryParam("screen", screenIdOrName).get(Screen.class);
    }

    public ScreensControl addTabToScreen(String screenName, String name) {
        this.get(this.createResource().path("addTab").queryParam("screen", "" + screenName).queryParam("name", name));
        return this;
    }

    public Response<Screen.Tab> addTabToScreenResponse(String screenName, String name) {
        return this.toResponse(() -> (ClientResponse)this.createResource().path("addTab").queryParam("screen", "" + screenName).queryParam("name", name).get(ClientResponse.class), Screen.Tab.class);
    }

    public ScreensControl deleteTabFromScreen(String screenName, String name) {
        this.get(this.createResource().path("deleteTab").queryParam("screen", "" + screenName).queryParam("name", name));
        return this;
    }

    public ScreensControl addFieldToScreen(String screenName, String fieldName) {
        return this.addFieldToScreen(screenName, fieldName, null, null);
    }

    public ScreensControl addFieldToScreen(String screenName, String fieldName, String tabName, String position) {
        WebResource query = this.createResource().path("addField").queryParam("screen", "" + screenName).queryParam("field", fieldName);
        if (tabName != null) {
            query = query.queryParam("tab", tabName);
        }
        if (position != null) {
            query = query.queryParam("position", position);
        }
        this.get(query);
        return this;
    }

    public ScreensControl setFieldPosition(String screenName, String fieldName, int position) {
        this.get(this.createResource().path("setFieldPosition").queryParam("screen", "" + screenName).queryParam("field", fieldName).queryParam("position", String.valueOf(position)));
        return this;
    }

    public ScreensControl removeFieldFromScreen(String screenName, String fieldName) {
        this.get(this.createResource().path("removeField").queryParam("screen", "" + screenName).queryParam("field", fieldName));
        return this;
    }

    @Override
    protected WebResource createResource() {
        return super.createResource().path("screens");
    }
}

