/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;

public class UserPreferencesControl
extends BackdoorControl<UserPreferencesControl> {
    private final String username;

    UserPreferencesControl(JIRAEnvironmentData environmentData, String username) {
        super(environmentData);
        this.username = username;
    }

    public UserPreferencesControl set(String name, String value) {
        return this.setPreference("string", name, value);
    }

    public UserPreferencesControl set(String name, Boolean value) {
        return this.setPreference("boolean", name, value);
    }

    public String getString(String name) {
        return (String)this.createResource().path(name).queryParam("type", "string").queryParam("username", this.username).get(String.class);
    }

    public Long getLong(String name) {
        return (Long)this.createResource().path(name).queryParam("type", "long").queryParam("username", this.username).get(Long.class);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.createResource().path(name).queryParam("type", "boolean").queryParam("username", this.username).get(Boolean.class);
    }

    public UserPreferencesControl set(String name, Long value) {
        return this.setPreference("long", name, value);
    }

    public UserPreferencesControl remove(String name) {
        this.createResource().path("preference").path(name).delete();
        return this;
    }

    @Override
    protected WebResource createResource() {
        return super.createResource().path("userProfile").path("preference");
    }

    private UserPreferencesControl setPreference(String type, String name, Object value) {
        this.createResource().path(name).queryParam("username", this.username).queryParam("type", type).type(MediaType.TEXT_PLAIN_TYPE).put((Object)value.toString());
        return this;
    }
}

