/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.net.URI;

public final class GenericRestClient
extends RestApiClient<GenericRestClient> {
    public GenericRestClient() {
        super(null);
    }

    public <T> Response<T> get(final URI path, Class<T> responseClass) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return GenericRestClient.this.getResource(path);
            }
        }, responseClass);
    }

    public <T> Response<T> get(final URI path, GenericType<T> responseType) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return GenericRestClient.this.getResource(path);
            }
        }, responseType);
    }

    public <T> Response<PageBean<T>> getNextPage(PageBean<T> currentPage, GenericType<PageBean<T>> actualPageType) {
        if (Boolean.TRUE.equals(currentPage.getIsLast()) || currentPage.getNextPage() == null) {
            throw new IllegalArgumentException("last page or next URL not specified");
        }
        return this.get(currentPage.getNextPage(), actualPageType);
    }

    private ClientResponse getResource(URI path) {
        return (ClientResponse)this.client().resource(path).queryParam("os_authType", "basic").queryParam("os_username", GenericRestClient.percentEncode(this.loginAs)).queryParam("os_password", GenericRestClient.percentEncode(this.loginPassword)).get(ClientResponse.class);
    }
}

