/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

public class ICalendarResourceClient
extends RestApiClient<ICalendarResourceClient> {
    public ICalendarResourceClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response<QueryOptions> getQueryOptions() {
        return this.toResponse(() -> (ClientResponse)this.createResource().path("config").path("query").path("options").get(ClientResponse.class), QueryOptions.class);
    }

    public Response validateJql(String jql) {
        MultivaluedMapImpl body = new MultivaluedMapImpl();
        body.put((Object)"jql", Collections.singletonList(jql));
        return this.toResponse(() -> this.lambda$validateJql$1((MultivaluedMap)body));
    }

    public Response<? extends Set> getConfigFields(String jql) {
        return this.toResponse(() -> (ClientResponse)this.createResource().path("config").path("fields").queryParam("jql", jql).get(ClientResponse.class), HashSet.class);
    }

    public Response searchWithJql(String jql, String ... dateFieldNames) {
        WebResource part = this.createResource().path("search").path("jql").path("events.ics").queryParam("jql", jql);
        WebResource resource = this.applyDateFieldNameQueryParams(part, dateFieldNames);
        return this.toResponse(() -> (ClientResponse)resource.get(ClientResponse.class));
    }

    public Response searchWithFilter(String filterId, String ... dateFieldNames) {
        WebResource part = this.createResource().path("search").path("filter").path("events.ics").queryParam("searchFilterId", filterId);
        WebResource resource = this.applyDateFieldNameQueryParams(part, dateFieldNames);
        return this.toResponse(() -> (ClientResponse)resource.get(ClientResponse.class));
    }

    @Override
    protected WebResource createResource() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("ical").path("1.0").path("ical");
    }

    private WebResource applyDateFieldNameQueryParams(WebResource part, String[] dateFieldNames) {
        if (dateFieldNames != null) {
            for (String name : dateFieldNames) {
                part = part.queryParam("dateFieldName", name);
            }
        }
        return part;
    }

    private /* synthetic */ ClientResponse lambda$validateJql$1(MultivaluedMap body) {
        return (ClientResponse)this.createResource().path("util").path("jql").path("validate").type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)body);
    }

    @XmlRootElement
    public static class SearchFilter
    implements Comparable<SearchFilter> {
        @XmlElement
        public long id;
        @XmlElement
        public String name;
        @XmlElement
        public String description;

        @Override
        public int compareTo(SearchFilter searchFilter) {
            int result = StringUtils.defaultString((String)this.name).compareTo(StringUtils.defaultString((String)searchFilter.name));
            return 0 == result ? (int)(this.id - searchFilter.id) : result;
        }
    }

    @XmlRootElement
    public static class SimpleProject
    implements Comparable<SimpleProject> {
        @XmlElement
        public String key;
        @XmlElement
        public String name;

        @Override
        public int compareTo(SimpleProject simpleProject) {
            int result = StringUtils.defaultString((String)this.name).compareTo(StringUtils.defaultString((String)simpleProject.name));
            return 0 == result ? this.key.compareTo(simpleProject.key) : result;
        }
    }

    @XmlRootElement
    public static class QueryOptions {
        @XmlElement
        public List<SimpleProject> projects;
        @XmlElement
        public List<SearchFilter> searchFilters;
        @XmlElement
        public String visibleFieldNames;
        @XmlElement
        public String visibleFunctionNamesJson;
        @XmlElement
        public String jqlReservedWordsJson;
        @XmlElement
        public boolean dateRangeSupported = true;
    }
}

