/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeAttributeBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public final class PermissionSchemeRestClient
extends RestApiClient<PermissionSchemeRestClient> {
    public PermissionSchemeRestClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response<PermissionSchemeListBean> getSchemes(final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource(), expands).get(ClientResponse.class);
            }
        }, new GenericType<PermissionSchemeListBean>(){});
    }

    public Response<PermissionSchemeBean> createScheme(final PermissionSchemeBean bean, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource(), expands).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)bean);
            }
        }, PermissionSchemeBean.class);
    }

    public Response<PermissionSchemeBean> getScheme(final Long id, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource().path(id.toString()), expands).get(ClientResponse.class);
            }
        }, PermissionSchemeBean.class);
    }

    public Response<PermissionSchemeBean> updateScheme(final Long id, final PermissionSchemeBean updateBean, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource().path(id.toString()), expands).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)updateBean);
            }
        }, PermissionSchemeBean.class);
    }

    public Response<?> deleteScheme(final Long id) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.resource().path(id.toString()).delete(ClientResponse.class);
            }
        });
    }

    public Response<PermissionGrantListBean> getPermissions(final Long schemeId, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource().path(schemeId.toString()).path("permission"), expands).get(ClientResponse.class);
            }
        }, new GenericType<PermissionGrantListBean>(){});
    }

    public Response<PermissionGrantBean> createPermission(final Long schemeId, final PermissionGrantBean bean, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource().path(schemeId.toString()).path("permission"), expands).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)bean);
            }
        }, PermissionGrantBean.class);
    }

    public Response<PermissionGrantBean> getPermission(final Long schemeId, final Long permissionId, final Expand ... expands) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.expandQuery(PermissionSchemeRestClient.this.resource().path(schemeId.toString()).path("permission").path(permissionId.toString()), expands).get(ClientResponse.class);
            }
        }, PermissionGrantBean.class);
    }

    public Response<?> deletePermission(final Long schemeId, final Long permissionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.resource().path(schemeId.toString()).path("permission").path(permissionId.toString()).delete(ClientResponse.class);
            }
        });
    }

    public Response<PermissionSchemeBean> getAssignedScheme(final String projectKeyOrId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.projectResource(projectKeyOrId).get(ClientResponse.class);
            }
        }, PermissionSchemeBean.class);
    }

    public Response<PermissionSchemeBean> assignScheme(final String projectKeyOrId, final Long schemeId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)PermissionSchemeRestClient.this.projectResource(projectKeyOrId).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)ImmutableMap.of((Object)"id", (Object)schemeId));
            }
        }, PermissionSchemeBean.class);
    }

    public Response<PermissionSchemeAttributeBean> getAttribute(Long schemeId, String attributeKey) {
        return this.toResponse(() -> (ClientResponse)this.resource().path(schemeId.toString()).path("attribute").path(attributeKey).get(ClientResponse.class), PermissionSchemeAttributeBean.class);
    }

    public Response<?> setAttribute(Long schemeId, PermissionSchemeAttributeBean attribute) {
        return this.toResponse(() -> (ClientResponse)this.resource().path(schemeId.toString()).path("attribute").path(attribute.getKey()).type("text/plain").put(ClientResponse.class, (Object)attribute.getValue()));
    }

    private WebResource resource() {
        return this.createResource().path("permissionscheme");
    }

    private WebResource projectResource(String projectKeyOrId) {
        return this.createResource().path("project").path(projectKeyOrId).path("permissionscheme");
    }

    private WebResource expandQuery(WebResource resource, Expand[] expands) {
        return expands.length > 0 ? resource.queryParam("expand", Joiner.on((char)',').join((Object[])expands)) : resource;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermissionSchemeListBean {
        @JsonProperty
        public List<PermissionSchemeBean> permissionSchemes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermissionGrantListBean {
        @JsonProperty
        public List<PermissionGrantBean> permissions;
    }

    public static enum Expand {
        permissions,
        user,
        group,
        projectRole,
        field,
        all;

    }
}

