/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Avatar;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectUpdateField;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class ProjectClient
extends RestApiClient<ProjectClient> {
    public ProjectClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Project get(String projectKey) throws UniformInterfaceException {
        return (Project)this.projectWithKey(projectKey).get(Project.class);
    }

    public Project getAndExpandAll(String projectKey) throws UniformInterfaceException {
        return (Project)this.projectWithKey(projectKey).queryParam("expand", "description,lead,url,projectKeys").get(Project.class);
    }

    public ClientResponse create(Object project) {
        return this.registerResponse((ClientResponse)((WebResource.Builder)this.projects().type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(ClientResponse.class, project));
    }

    public ClientResponse update(String keyOrId, UpdateBean newData) {
        return this.registerResponse((ClientResponse)((WebResource.Builder)this.projectWithKey(keyOrId).type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).put(ClientResponse.class, (Object)newData.json));
    }

    public Response<Project> updateProjectType(final String keyOrId, final String newProjectTypeKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ProjectClient.this.projectWithKey(keyOrId).path("type").path(newProjectTypeKey).put(ClientResponse.class);
            }
        }, Project.class);
    }

    public ClientResponse delete(String keyOrId) {
        return this.registerResponse((ClientResponse)((WebResource.Builder)this.projectWithKey(keyOrId).type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).delete(ClientResponse.class));
    }

    public List<Project> getProjects() {
        return (List)this.projects().get(Project.PROJECTS_TYPE);
    }

    public List<Project> getProjects(String expand) {
        return (List)this.projects(expand).get(Project.PROJECTS_TYPE);
    }

    public ClientResponse getRecentProjects(String expand, int count) {
        return (ClientResponse)this.projects(expand).queryParam("recent", String.valueOf(count)).get(ClientResponse.class);
    }

    public ClientResponse getRecentProjects(int count) {
        return this.registerResponse((ClientResponse)this.projects().queryParam("recent", String.valueOf(count)).get(ClientResponse.class));
    }

    public List<Version> getVersions(String key) {
        return (List)this.projectVersionWithKey(key).get(Version.VERSIONS_TYPE);
    }

    public PageBean<Version> getVersionsPaged(String key, Long startAt, Integer maxResults, String orderBy) {
        WebResource webResource = this.projectVersionsPaged(key);
        if (startAt != null) {
            webResource = webResource.queryParam("startAt", startAt.toString());
        }
        if (maxResults != null) {
            webResource = webResource.queryParam("maxResults", maxResults.toString());
        }
        if (orderBy != null) {
            webResource = webResource.queryParam("orderBy", orderBy);
        }
        return (PageBean)webResource.get(Version.VERSIONS_PAGED_TYPE);
    }

    public Map<String, List<Avatar>> getAvatars(String key) {
        return (Map)this.projectWithKey(key).path("avatars").get(Avatar.ALLAVATARS_TYPE);
    }

    public Avatar getAvatar(String key, Long id) {
        return (Avatar)this.projectWithKey(key).path("avatar").path(id.toString()).get(Avatar.AVATAR_TYPE);
    }

    public Response getResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ProjectClient.this.projectWithKey(projectKey).get(ClientResponse.class);
            }
        });
    }

    public Response getVersionsResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ProjectClient.this.projectWithKey(projectKey).get(ClientResponse.class);
            }
        });
    }

    public List<Component> getComponents(String key) {
        return (List)this.projectComponentWithKey(key).get(Component.COMPONENTS_TYPE);
    }

    public ClientResponse archive(String projectIdOrKey) {
        ClientResponse response = (ClientResponse)this.projects().path(projectIdOrKey).path("archive").put(ClientResponse.class);
        response.close();
        return response;
    }

    public ClientResponse restore(String projectIdOrKey) {
        ClientResponse response = (ClientResponse)this.projects().path(projectIdOrKey).path("restore").put(ClientResponse.class);
        response.close();
        return response;
    }

    protected WebResource projectWithKey(String projectKey) {
        return this.projects().path(projectKey);
    }

    protected WebResource projectVersionWithKey(String projectKey) {
        return this.projectWithKey(projectKey).path("versions");
    }

    protected WebResource projectVersionsPaged(String projectKey) {
        return this.projectWithKey(projectKey).path("version");
    }

    protected WebResource projectComponentWithKey(String projectKey) {
        return this.projectWithKey(projectKey).path("components");
    }

    protected WebResource projects() {
        return this.createResource().path("project");
    }

    protected WebResource projects(String expand) {
        return this.projects().queryParam("expand", expand);
    }

    public static class UpdateBean {
        private final Map<String, String> json;

        private UpdateBean(Map<ProjectUpdateField, String> fieldsToUpdate) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ProjectUpdateField field : fieldsToUpdate.keySet()) {
                mapBuilder.put((Object)field.jsonFieldName(), (Object)fieldsToUpdate.get((Object)field));
            }
            this.json = mapBuilder.build();
        }

        public Map<String, String> getJson() {
            return Maps.newHashMap(this.json);
        }

        public static UpdateBeanBuilder builder() {
            return new UpdateBeanBuilder(Collections.emptyMap());
        }

        public static class UpdateBeanBuilder {
            private final Map<ProjectUpdateField, String> builder;

            public UpdateBeanBuilder(Map<ProjectUpdateField, String> builder) {
                this.builder = builder;
            }

            public UpdateBeanBuilder with(ProjectUpdateField field, Object value) {
                ImmutableMap newMap = ImmutableMap.builder().putAll(this.builder).put((Object)field, (Object)value.toString()).build();
                return new UpdateBeanBuilder((Map<ProjectUpdateField, String>)newMap);
            }

            public UpdateBean build() {
                return new UpdateBean(this.builder);
            }
        }
    }
}

