/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleActorsUpdate;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient2;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;

public class ProjectRoleClient
extends RestApiClient<ProjectRoleClient> {
    protected final ProjectRoleClient2 projectRoleClient2;
    public GenericType<Map<String, String>> TYPE = new GenericType(HashMap.class);

    public ProjectRoleClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.projectRoleClient2 = new ProjectRoleClient2(environmentData);
    }

    public Map<String, String> get(String projectKey) throws UniformInterfaceException {
        return (Map)this.rolesWithProjectKey(projectKey).get(this.TYPE);
    }

    public void deleteRole(String name) {
        this.projectRoleClient2.deleteRole(name);
    }

    public ProjectRole get(String projectKey, String role) {
        WebResource webResource = this.resourceRoot(this.get(projectKey).get(role));
        return (ProjectRole)webResource.get(ProjectRole.class);
    }

    public Response addActors(String projectKey, String role, @Nullable String[] groupNames, @Nullable String[] userNames) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebResource webResource = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
            HashMap parameter = Maps.newHashMap();
            if (groupNames != null) {
                parameter.put("group", groupNames);
            }
            if (userNames != null) {
                parameter.put("user", userNames);
            }
            return (ClientResponse)webResource.type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)parameter);
        });
    }

    public Response deleteGroup(String projectKey, String role, String groupName) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebResource webResource = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("group", groupName);
            return (ClientResponse)webResource.delete(ClientResponse.class);
        });
    }

    public Response deleteUser(String projectKey, String role, String userName) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebResource webResource = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString()).queryParam("user", userName);
            return (ClientResponse)webResource.delete(ClientResponse.class);
        });
    }

    protected WebResource rolesWithProjectKey(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("role");
    }

    public Response setActors(String projectKey, String role, Map<String, String[]> actors) {
        ProjectRole projectRole = this.get(projectKey, role);
        return this.toResponse(() -> {
            WebResource webResource = this.rolesWithProjectKey(projectKey).path(projectRole.id.toString());
            ProjectRoleActorsUpdate projectRoleActorsUpdate = new ProjectRoleActorsUpdate(projectRole.id, actors);
            return (ClientResponse)webResource.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)projectRoleActorsUpdate);
        });
    }
}

