/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.VersionIssueCounts;
import com.atlassian.jira.testkit.client.restclient.VersionMove;
import com.atlassian.jira.testkit.client.restclient.VersionUnresolvedIssueCount;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import javax.ws.rs.core.MediaType;

public class VersionClient
extends RestApiClient<VersionClient> {
    public VersionClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Version get(String versionID) throws UniformInterfaceException {
        return (Version)this.versionWithID(versionID).get(Version.class);
    }

    public Response getResponse(final String versionID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionID).get(ClientResponse.class);
            }
        });
    }

    public Version create(Version version) throws UniformInterfaceException {
        return (Version)this.version().post(Version.class, (Object)version);
    }

    public Response createResponse(final Version version) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.version().post(ClientResponse.class, (Object)version);
            }
        });
    }

    public Response delete(String versionId) throws UniformInterfaceException {
        return this.delete(versionId, null, null);
    }

    public Response delete(final String versionId, final URI swapFixVersion, final URI swapAffectedVersion) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource deleteResource = VersionClient.this.versionWithID(versionId);
                if (swapFixVersion != null) {
                    deleteResource = deleteResource.queryParam("moveFixIssuesTo", swapFixVersion.getPath());
                }
                if (swapAffectedVersion != null) {
                    deleteResource = deleteResource.queryParam("moveAffectedIssuesTo", swapAffectedVersion.getPath());
                }
                return (ClientResponse)deleteResource.delete(ClientResponse.class);
            }
        });
    }

    public Response deleteVersionAndSwap(String versionId, DeleteVersionWithCustomFieldParameters parameters) throws UniformInterfaceException {
        return this.toResponse(() -> {
            WebResource removeAndSwapResource = this.versionWithID(versionId).path("removeAndSwap");
            return (ClientResponse)removeAndSwapResource.entity((Object)parameters, MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class);
        });
    }

    public Response merge(String versionId, String mergeToVersionId) throws UniformInterfaceException {
        return this.toResponse(() -> {
            WebResource mergeResource = this.versionWithID(versionId).path("mergeto").path(mergeToVersionId);
            return (ClientResponse)mergeResource.put(ClientResponse.class);
        });
    }

    public Version move(String versionId, VersionMove versionMove) throws UniformInterfaceException {
        return (Version)this.versionMove(versionId).post(Version.class, (Object)versionMove);
    }

    public Response moveResponse(final String versionId, final VersionMove versionMove) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionMove(versionId).post(ClientResponse.class, (Object)versionMove);
            }
        });
    }

    public Version archive(String versionID) {
        return (Version)this.versionWithID(versionID).type(MediaType.APPLICATION_JSON_TYPE).put(Version.class, (Object)new Version().archived(true));
    }

    public Version unarchive(String versionID) {
        return (Version)this.versionWithID(versionID).type(MediaType.APPLICATION_JSON_TYPE).put(Version.class, (Object)new Version().archived(false));
    }

    public Version release(String versionID) {
        return (Version)this.versionWithID(versionID).type(MediaType.APPLICATION_JSON_TYPE).put(Version.class, (Object)new Version().released(true));
    }

    public Version unrelease(String versionID) {
        return (Version)this.versionWithID(versionID).type(MediaType.APPLICATION_JSON_TYPE).put(Version.class, (Object)new Version().released(false));
    }

    public VersionIssueCounts getVersionIssueCounts(String versionID) throws UniformInterfaceException {
        return (VersionIssueCounts)this.versionWithID(versionID).path("relatedIssueCounts").get(VersionIssueCounts.class);
    }

    public Response getVersionIssueCountsResponse(final String versionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).path("relatedIssueCounts").get(ClientResponse.class);
            }
        });
    }

    public VersionUnresolvedIssueCount getVersionUnresolvedIssueCount(String versionID) throws UniformInterfaceException {
        return (VersionUnresolvedIssueCount)this.versionWithID(versionID).path("unresolvedIssueCount").get(VersionUnresolvedIssueCount.class);
    }

    public Response getVersionUnresolvedIssueCountResponse(final String versionId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).path("unresolvedIssueCount").get(ClientResponse.class);
            }
        });
    }

    public Response putResponse(final String versionId, final Version version) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)VersionClient.this.versionWithID(versionId).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)version);
            }
        });
    }

    public Response putResponse(Version version) {
        String[] selfParts = version.self.split("/");
        String versionId = selfParts[selfParts.length - 1];
        return this.putResponse(versionId, version);
    }

    private WebResource versionWithID(String versionID) {
        return this.createResource().path("version").path(versionID);
    }

    private WebResource.Builder version() {
        return this.createResource().path("version").type(MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource.Builder versionMove(String versionID) {
        return this.createResource().path("version").path(versionID).path("move").type(MediaType.APPLICATION_JSON_TYPE);
    }
}

