/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import javax.ws.rs.core.MediaType;

public class WatchersClient
extends RestApiClient<WatchersClient> {
    public WatchersClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Watches get(String issueKey) throws UniformInterfaceException {
        return (Watches)this.watchersForIssueWithKey(issueKey).get(Watches.class);
    }

    public Response getResponse(final String issueKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WatchersClient.this.watchersForIssueWithKey(issueKey).get(ClientResponse.class);
            }
        });
    }

    public Response postResponse(final String issueKey, final String username) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                if (username == null) {
                    return (ClientResponse)WatchersClient.this.watchersForIssueWithKey(issueKey).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class);
                }
                return (ClientResponse)WatchersClient.this.watchersForIssueWithKey(issueKey).type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)String.format("\"%s\"", username));
            }
        });
    }

    public Response deleteResponse(final String issueKey, final String username) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)WatchersClient.this.watchersForIssueWithKey(issueKey).queryParam("username", username).delete(ClientResponse.class);
            }
        });
    }

    private WebResource watchersForIssueWithKey(String issueKey) {
        return this.createResource().path("issue").path(issueKey).path("watchers");
    }
}

