/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient.matcher;

import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.util.collect.Transformed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class IsCollectionOf<T>
extends TypeSafeMatcher<Collection<T>> {
    private final Collection<T> expected;

    public IsCollectionOf(Collection<T> expected) {
        this.expected = expected;
    }

    public boolean matchesSafely(Collection<T> given) {
        ArrayList<T> tmp = new ArrayList<T>(this.expected);
        for (T t : given) {
            if (tmp.remove(t)) continue;
            return false;
        }
        return tmp.isEmpty();
    }

    public static Matcher<Collection<String>> ofProjectKeys(List<Project> projects) {
        Collection projectKeys = Transformed.collection(projects, project -> project.key);
        return new IsCollectionOf(projectKeys);
    }

    public static <T> Matcher<Collection<T>> ofItems(T ... items) {
        return new IsCollectionOf<T>(Arrays.asList(items));
    }

    public void describeTo(Description description) {
        description.appendText(this.expected.toString());
    }
}

