/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.rules;

import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.util.Supplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.rules.ExternalResource;

public class IssueTypeUrlsRule
extends ExternalResource {
    private final Pattern pattern = Pattern.compile(".*?avatarId=(\\d+).*?");
    private final Supplier<Backdoor> backdoorSupplier;
    private Map<String, IssueTypeControl.IssueType> nameToIssueTypeMap;

    public IssueTypeUrlsRule(Supplier<Backdoor> backdoorSupplier) {
        this.backdoorSupplier = backdoorSupplier;
    }

    @Deprecated
    public void init() {
        try {
            this.before();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected void before() throws Throwable {
        List<IssueTypeControl.IssueType> issueTypes = ((Backdoor)this.backdoorSupplier.get()).issueType().getIssueTypes();
        this.nameToIssueTypeMap = new HashMap<String, IssueTypeControl.IssueType>();
        for (IssueTypeControl.IssueType issueType : issueTypes) {
            this.nameToIssueTypeMap.put(issueType.getName().toLowerCase(), issueType);
        }
    }

    public String getIssueTypeUrl(String issueTypeName) {
        IssueTypeControl.IssueType issueType = this.nameToIssueTypeMap.get(issueTypeName.toLowerCase());
        return issueType != null ? issueType.getIconUrl() : null;
    }

    public Long getAvatarId(String issueTypeName) {
        IssueTypeControl.IssueType issueType = this.nameToIssueTypeMap.get(issueTypeName.toLowerCase());
        Matcher matcher = this.pattern.matcher(issueType.getIconUrl());
        if (matcher.find()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

