/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Priority;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class PriorityControl
extends BackdoorControl<PriorityControl> {
    private static final GenericType<List<Priority>> LIST_GENERIC_TYPE = new GenericType<List<Priority>>(){};

    public PriorityControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Priority createPriority(String name, String description, String color, String iconUrl) {
        Priority priority = new Priority();
        priority.setName(name);
        priority.setDescription(description);
        priority.setColor(color);
        priority.setIconUrl(iconUrl);
        return (Priority)this.createPriorityResource().post(Priority.class, (Object)priority);
    }

    public Priority editPriority(long id, String name, String description, String color, String iconUrl) {
        Priority priority = new Priority();
        priority.setId(String.valueOf(id));
        priority.setName(name);
        priority.setDescription(description);
        priority.setColor(color);
        priority.setIconUrl(iconUrl);
        return (Priority)this.createPriorityResource().put(Priority.class, (Object)priority);
    }

    public List<Priority> getPriorities() {
        return (List)this.createPriorityResource().get(LIST_GENERIC_TYPE);
    }

    public void deletePriority(long id) {
        this.createPriorityResource().path(String.valueOf(id)).delete();
    }

    public void setDefaultPriority(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("default").post();
    }

    public void movePriorityUp(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("up").post();
    }

    public void movePriorityDown(long id) {
        this.createPriorityResource().path(String.valueOf(id)).path("down").post();
    }

    private WebResource createPriorityResource() {
        return this.createResource().path("priority");
    }
}

