/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChangeLog {
    public int startAt;
    public int maxResults;
    public int total;
    public List<History> histories;

    public List<HistoryItem> mergeHistoryItems() {
        ArrayList items = Lists.newArrayList();
        for (History history : this.histories) {
            if (history.items == null) continue;
            items.addAll(history.items);
        }
        return items;
    }

    public int getStartAt() {
        return this.startAt;
    }

    public ChangeLog setStartAt(int startAt) {
        this.startAt = startAt;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public ChangeLog setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public int getTotal() {
        return this.total;
    }

    public ChangeLog setTotal(int total) {
        this.total = total;
        return this;
    }

    public List<History> getHistories() {
        return this.histories;
    }

    public ChangeLog setHistories(List<History> histories) {
        this.histories = histories;
        return this;
    }

    public History addHistory() {
        History history = new History();
        this.histories.add(history);
        return history;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Author {
        public String key;
        public String name;
        public String emailAddress;

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class HistoryItem {
        public String field;
        public String fieldtype;
        public String from;
        public String fromString;
        public String to;
        public String toString;

        public String getField() {
            return this.field;
        }

        public HistoryItem setField(String field) {
            this.field = field;
            return this;
        }

        public String getFieldtype() {
            return this.fieldtype;
        }

        public HistoryItem setFieldtype(String fieldtype) {
            this.fieldtype = fieldtype;
            return this;
        }

        public String getFrom() {
            return this.from;
        }

        public HistoryItem setFrom(String from) {
            this.from = from;
            return this;
        }

        public String getFromString() {
            return this.fromString;
        }

        public HistoryItem setFromString(String fromString) {
            this.fromString = fromString;
            return this;
        }

        public String getTo() {
            return this.to;
        }

        public HistoryItem setTo(String to) {
            this.to = to;
            return this;
        }

        public String getToString() {
            return this.toString;
        }

        public HistoryItem setToString(String toString) {
            this.toString = toString;
            return this;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class History {
        public long id;
        public String created;
        public Author author;
        public List<HistoryItem> items;

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public long getId() {
            return this.id;
        }

        public History setId(long id) {
            this.id = id;
            return this;
        }

        public List<HistoryItem> getItems() {
            return this.items;
        }

        public void setItems(List<HistoryItem> items) {
            this.items = items;
        }

        public History setAuthor(Author author) {
            this.author = author;
            return this;
        }

        public Author getAuthor() {
            return this.author;
        }

        public String getCreated() {
            return this.created;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public HistoryItem addHistory() {
            HistoryItem item = new HistoryItem();
            this.items.add(item);
            return item;
        }
    }
}

